/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletContext;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.bonitasoft.web.designer.workspace.WorkspaceInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletContext;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceInitializerTest {
    private static final String WAR_BASE_PATH = "src/main/webapp";
    @Mock
    private LiveRepositoryUpdate<Page> pageRepositoryLiveUpdate;
    @Mock
    private LiveRepositoryUpdate<Widget> widgetRepositoryLiveUpdate;
    @Mock
    private Workspace workspace;
    @InjectMocks
    private WorkspaceInitializer workspaceInitializer;

    @Before
    public void initializeWorkspaceInitializer() {
        this.workspaceInitializer.setServletContext((ServletContext)new MockServletContext(WAR_BASE_PATH, (ResourceLoader)new FileSystemResourceLoader()));
        this.workspaceInitializer.setMigrations(Arrays.asList(this.pageRepositoryLiveUpdate, this.widgetRepositoryLiveUpdate));
    }

    @Test
    public void should_initialize_workspace() throws Exception {
        this.workspaceInitializer.contextInitialized();
        ((Workspace)Mockito.verify((Object)this.workspace)).initialize();
        ((Workspace)Mockito.verify((Object)this.workspace)).cleanPageWorkspace();
    }

    @Test
    public void should_start_page_live_migration() throws Exception {
        this.workspaceInitializer.contextInitialized();
        ((LiveRepositoryUpdate)Mockito.verify(this.pageRepositoryLiveUpdate)).start();
    }

    @Test
    public void should_start_widget_live_migration() throws Exception {
        this.workspaceInitializer.contextInitialized();
        ((LiveRepositoryUpdate)Mockito.verify(this.widgetRepositoryLiveUpdate)).start();
    }

    @Test(expected=RuntimeException.class)
    public void should_throw_runtimeException_if_error_occurs_while_initializing_workspace() throws Exception {
        ((Workspace)Mockito.doThrow((Throwable)new IOException()).when((Object)this.workspace)).initialize();
        this.workspaceInitializer.contextInitialized();
    }
}

