
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbChart {

    private String cssClasses;
    private Boolean hidden = false;
    private PbChart.Type type = PbChart.Type.fromValue("Doughnut");
    private String data = "";
    private String labels = "";
    private String setLabels = "";
    private Boolean legendHidden = true;
    private String colors;
    private String options;

    /**
     * 
     * @return
     *     The cssClasses
     */
    public String getCssClasses() {
        return cssClasses;
    }

    /**
     * 
     * @param cssClasses
     *     The cssClasses
     */
    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    /**
     * 
     * @return
     *     The hidden
     */
    public Boolean getHidden() {
        return hidden;
    }

    /**
     * 
     * @param hidden
     *     The hidden
     */
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    /**
     * 
     * @return
     *     The type
     */
    public PbChart.Type getType() {
        return type;
    }

    /**
     * 
     * @param type
     *     The type
     */
    public void setType(PbChart.Type type) {
        this.type = type;
    }

    /**
     * 
     * @return
     *     The data
     */
    public String getData() {
        return data;
    }

    /**
     * 
     * @param data
     *     The data
     */
    public void setData(String data) {
        this.data = data;
    }

    /**
     * 
     * @return
     *     The labels
     */
    public String getLabels() {
        return labels;
    }

    /**
     * 
     * @param labels
     *     The labels
     */
    public void setLabels(String labels) {
        this.labels = labels;
    }

    /**
     * 
     * @return
     *     The setLabels
     */
    public String getSetLabels() {
        return setLabels;
    }

    /**
     * 
     * @param setLabels
     *     The setLabels
     */
    public void setSetLabels(String setLabels) {
        this.setLabels = setLabels;
    }

    /**
     * 
     * @return
     *     The legendHidden
     */
    public Boolean getLegendHidden() {
        return legendHidden;
    }

    /**
     * 
     * @param legendHidden
     *     The legendHidden
     */
    public void setLegendHidden(Boolean legendHidden) {
        this.legendHidden = legendHidden;
    }

    /**
     * 
     * @return
     *     The colors
     */
    public String getColors() {
        return colors;
    }

    /**
     * 
     * @param colors
     *     The colors
     */
    public void setColors(String colors) {
        this.colors = colors;
    }

    /**
     * 
     * @return
     *     The options
     */
    public String getOptions() {
        return options;
    }

    /**
     * 
     * @param options
     *     The options
     */
    public void setOptions(String options) {
        this.options = options;
    }

    public enum Type {

        DOUGHNUT("Doughnut"),
        PIE("Pie"),
        POLAR_AREA("PolarArea"),
        BAR("Bar"),
        LINE("Line"),
        RADAR("Radar");
        private final String value;
        private final static Map<String, PbChart.Type> CONSTANTS = new HashMap<String, PbChart.Type>();

        static {
            for (PbChart.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbChart.Type fromValue(String value) {
            PbChart.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
