
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbDataTable {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean allowHTML = true;
    private String headers = "";
    private PbDataTable.Type type = PbDataTable.Type.fromValue("Bonita API");
    private String apiUrl = "../API/";
    private String params;
    private String content;
    private String columnsKey;
    private String sortColumns;
    private String selectedRow;
    private Double pageSize = 10.0D;
    private String filter;
    private Boolean striped = true;
    private Boolean condensed = false;
    private Boolean bordered = false;

    /**
     * 
     * @return
     *     The cssClasses
     */
    public String getCssClasses() {
        return cssClasses;
    }

    /**
     * 
     * @param cssClasses
     *     The cssClasses
     */
    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    /**
     * 
     * @return
     *     The hidden
     */
    public Boolean getHidden() {
        return hidden;
    }

    /**
     * 
     * @param hidden
     *     The hidden
     */
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    /**
     * 
     * @return
     *     The allowHTML
     */
    public Boolean getAllowHTML() {
        return allowHTML;
    }

    /**
     * 
     * @param allowHTML
     *     The allowHTML
     */
    public void setAllowHTML(Boolean allowHTML) {
        this.allowHTML = allowHTML;
    }

    /**
     * 
     * @return
     *     The headers
     */
    public String getHeaders() {
        return headers;
    }

    /**
     * 
     * @param headers
     *     The headers
     */
    public void setHeaders(String headers) {
        this.headers = headers;
    }

    /**
     * 
     * @return
     *     The type
     */
    public PbDataTable.Type getType() {
        return type;
    }

    /**
     * 
     * @param type
     *     The type
     */
    public void setType(PbDataTable.Type type) {
        this.type = type;
    }

    /**
     * 
     * @return
     *     The apiUrl
     */
    public String getApiUrl() {
        return apiUrl;
    }

    /**
     * 
     * @param apiUrl
     *     The apiUrl
     */
    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    /**
     * 
     * @return
     *     The params
     */
    public String getParams() {
        return params;
    }

    /**
     * 
     * @param params
     *     The params
     */
    public void setParams(String params) {
        this.params = params;
    }

    /**
     * 
     * @return
     *     The content
     */
    public String getContent() {
        return content;
    }

    /**
     * 
     * @param content
     *     The content
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 
     * @return
     *     The columnsKey
     */
    public String getColumnsKey() {
        return columnsKey;
    }

    /**
     * 
     * @param columnsKey
     *     The columnsKey
     */
    public void setColumnsKey(String columnsKey) {
        this.columnsKey = columnsKey;
    }

    /**
     * 
     * @return
     *     The sortColumns
     */
    public String getSortColumns() {
        return sortColumns;
    }

    /**
     * 
     * @param sortColumns
     *     The sortColumns
     */
    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    /**
     * 
     * @return
     *     The selectedRow
     */
    public String getSelectedRow() {
        return selectedRow;
    }

    /**
     * 
     * @param selectedRow
     *     The selectedRow
     */
    public void setSelectedRow(String selectedRow) {
        this.selectedRow = selectedRow;
    }

    /**
     * 
     * @return
     *     The pageSize
     */
    public Double getPageSize() {
        return pageSize;
    }

    /**
     * 
     * @param pageSize
     *     The pageSize
     */
    public void setPageSize(Double pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * 
     * @return
     *     The filter
     */
    public String getFilter() {
        return filter;
    }

    /**
     * 
     * @param filter
     *     The filter
     */
    public void setFilter(String filter) {
        this.filter = filter;
    }

    /**
     * 
     * @return
     *     The striped
     */
    public Boolean getStriped() {
        return striped;
    }

    /**
     * 
     * @param striped
     *     The striped
     */
    public void setStriped(Boolean striped) {
        this.striped = striped;
    }

    /**
     * 
     * @return
     *     The condensed
     */
    public Boolean getCondensed() {
        return condensed;
    }

    /**
     * 
     * @param condensed
     *     The condensed
     */
    public void setCondensed(Boolean condensed) {
        this.condensed = condensed;
    }

    /**
     * 
     * @return
     *     The bordered
     */
    public Boolean getBordered() {
        return bordered;
    }

    /**
     * 
     * @param bordered
     *     The bordered
     */
    public void setBordered(Boolean bordered) {
        this.bordered = bordered;
    }

    public enum Type {

        VARIABLE("Variable"),
        BONITA_API("Bonita API");
        private final String value;
        private final static Map<String, PbDataTable.Type> CONSTANTS = new HashMap<String, PbDataTable.Type>();

        static {
            for (PbDataTable.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbDataTable.Type fromValue(String value) {
            PbDataTable.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
