/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.PropertyValue;

public class FormContainerBuilder
extends ElementBuilder<FormContainer> {
    private FormContainer formContainer = new FormContainer();
    private String reference = "formcontainer-reference";
    private String id = "pbFormContainer";

    private FormContainerBuilder() {
        this.formContainer.setReference(this.reference);
        this.formContainer.setId(this.id);
    }

    public static FormContainerBuilder aFormContainer() {
        return new FormContainerBuilder();
    }

    public FormContainerBuilder with(Container container) {
        this.formContainer.setContainer(container);
        return this;
    }

    public FormContainerBuilder with(ContainerBuilder container) {
        return this.with(container.build());
    }

    public FormContainerBuilder name(String name) {
        this.setParameter("name", name);
        return this;
    }

    @Override
    public FormContainer build() {
        return this.formContainer;
    }

    @Override
    public FormContainer getElement() {
        return this.formContainer;
    }

    private void setParameter(String key, String name) {
        PropertyValue value = (PropertyValue)this.formContainer.getPropertyValues().get(key);
        if (value == null) {
            value = new PropertyValue();
            value.setType("string");
            value.setValue((Object)name);
            this.formContainer.getPropertyValues().put(key, value);
        } else {
            value.setValue((Object)name);
        }
    }
}

