/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;

public class VariableBuilder {
    private DataType type;
    private String value;
    private boolean exposed;

    public VariableBuilder(DataType type) {
        this.type = type;
    }

    public static VariableBuilder aConstantVariable() {
        return new VariableBuilder(DataType.CONSTANT);
    }

    public static VariableBuilder aJSONVariable() {
        return new VariableBuilder(DataType.JSON);
    }

    public static VariableBuilder anURLVariable() {
        return new VariableBuilder(DataType.URL);
    }

    public static VariableBuilder aUrlParameterVariable() {
        return new VariableBuilder(DataType.URLPARAMETER);
    }

    public static VariableBuilder anExpressionVariable() {
        return new VariableBuilder(DataType.EXPRESSION);
    }

    public VariableBuilder value(String value) {
        this.value = value;
        return this;
    }

    public VariableBuilder exposed(boolean exposed) {
        this.exposed = exposed;
        return this;
    }

    public Variable build() {
        Variable variable = new Variable(this.type, this.value);
        variable.setExposed(this.exposed);
        return variable;
    }
}

