/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.util.Collections;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.controller.MigrationResource;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationResourceFragmentTest {
    private MockMvc mockMvc;
    @InjectMocks
    private MigrationResource migrationResource;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private FragmentService fragmentService;

    @Before
    public void setUp() {
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        ReflectionTestUtils.setField((Object)this.migrationResource, (String)"modelVersion", (Object)"2.0");
    }

    @Test
    public void should_return_200_when_fragment_migration_is_done_on_success() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").withName("my-fragment").build();
        Mockito.when((Object)this.fragmentRepository.get("my-fragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.migrateWithReport((Identifiable)fragment)).thenReturn((Object)new MigrationResult((Object)fragment, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "my-fragment"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/my-fragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).migrateWithReport((Identifiable)fragment);
    }

    @Test
    public void should_return_200_when_fragment_migration_is_finished_with_warning() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").withName("my-fragment").build();
        Mockito.when((Object)this.fragmentRepository.get("my-fragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.migrateWithReport((Identifiable)fragment)).thenReturn((Object)new MigrationResult((Object)fragment, Collections.singletonList(new MigrationStepReport(MigrationStatus.WARNING, "my-fragment"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/my-fragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).migrateWithReport((Identifiable)fragment);
    }

    @Test
    public void should_return_500_when_an_error_occurs_during_fragment_migration() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").withName("my-fragment").build();
        Mockito.when((Object)this.fragmentRepository.get("my-fragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.migrateWithReport((Identifiable)fragment)).thenReturn((Object)new MigrationResult((Object)fragment, Collections.singletonList(new MigrationStepReport(MigrationStatus.ERROR, "my-fragment"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/my-fragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(500));
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).migrateWithReport((Identifiable)fragment);
    }

    @Test
    public void should_return_404_when_migration_is_trigger_but_fragment_id_doesnt_exist() throws Exception {
        Mockito.when((Object)this.fragmentRepository.get("unknownFragment")).thenThrow(new Throwable[]{new NotFoundException()});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/unknownFragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_fragment_version_is_incompatible() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").withModelVersion("3.0").withName("my-fragment").withMigrationStatusReport(new MigrationStatusReport(false, true)).build();
        Mockito.when((Object)this.fragmentRepository.get("my-fragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)new MigrationStatusReport(false, false));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/my-fragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"Artifact is incompatible with actual version\",\"status\":\"incompatible\",\"elementId\":\"my-fragment\",\"migrationStepReport\":[]}");
        ((FragmentService)Mockito.verify((Object)this.fragmentService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)fragment);
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_fragment_not_needed_migration() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("my-fragment").withModelVersion("2.0").withName("my-fragment").isMigration(false).build();
        Mockito.when((Object)this.fragmentRepository.get("my-fragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.migrateWithReport((Identifiable)fragment)).thenReturn((Object)new MigrationResult((Object)fragment, Collections.singletonList(new MigrationStepReport(MigrationStatus.ERROR, "my-fragment"))));
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/fragment/my-fragment", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"No migration is needed\",\"status\":\"none\",\"elementId\":\"my-fragment\",\"migrationStepReport\":[]}");
        ((FragmentService)Mockito.verify((Object)this.fragmentService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)fragment);
    }

    @Test
    public void should_return_artifact_status_when_migration_required() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withDesignerVersion("1.10.0").withPreviousDesignerVersion("1.9.0").withMigrationStatusReport(new MigrationStatusReport(true, true)).build();
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)fragment);
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("myFragment").withName("myFragment").withDesignerVersion("1.10.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment2);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment2)).thenReturn((Object)new MigrationStatusReport(true, true));
        result = this.getStatusRequestById("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_artifact_status_when_no_migration_required() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.0").withMigrationStatusReport(new MigrationStatusReport(true, false)).build();
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)fragment);
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("myFragment").withName("myFragment").withDesignerVersion("2.0").withMigrationStatusReport(new MigrationStatusReport(true, false)).build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment2);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment2)).thenReturn((Object)new MigrationStatusReport(true, false));
        result = this.getStatusRequestById("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_artifact_status_when_not_compatible_required() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.1").isMigration(false).isCompatible(false).build();
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)fragment);
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        Fragment fragment2 = FragmentBuilder.aFragment().id("myFragment").withName("myFragment").withDesignerVersion("2.1").isMigration(false).isCompatible(false).build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment2);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment2)).thenReturn((Object)new MigrationStatusReport(false, false));
        result = this.getStatusRequestById("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_to_migrate() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)new MigrationStatusReport(true, true));
        ResultActions result = this.getStatusRequestByIdRecursive("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_not_compatible() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)new MigrationStatusReport(false, false));
        ResultActions result = this.getStatusRequestByIdRecursive("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_not_to_migrate() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().id("myFragment").withModelVersion("2.0").build();
        Mockito.when((Object)this.fragmentRepository.get("myFragment")).thenReturn((Object)fragment);
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)new MigrationStatusReport(true, false));
        ResultActions result = this.getStatusRequestByIdRecursive("fragment", "myFragment");
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_not_found_when_invalid_artifact_id() throws Exception {
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.migrationResource).build();
        Mockito.when((Object)this.fragmentRepository.get("invalidFragmentId")).thenThrow(new Throwable[]{new NotFoundException()});
        this.getStatusRequestByIdInvalid("fragment", "invalidFragmentId");
    }

    private ResultActions postStatusRequest(DesignerArtifact artifact) throws Exception {
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/migration/status", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(artifact))).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private ResultActions getStatusRequestById(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s", artifactType, artifactId);
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private String getStatusReport(boolean compatible, boolean migration) {
        return new MigrationStatusReport(compatible, migration).toString();
    }

    private void getStatusRequestByIdInvalid(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s", artifactType, artifactId);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private ResultActions getStatusRequestByIdRecursive(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s?recursive=true", artifactType, artifactId);
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }
}

