/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.net.URISyntaxException;
import java.util.Collections;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.MigrationResource;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.utils.RestControllerUtil;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.http.MediaType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationResourceTest {
    private MockMvc mockMvc;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private PageService pageService;
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private WidgetService widgetService;
    @InjectMocks
    private MigrationResource MigrationResource;

    @Before
    public void setUp() throws URISyntaxException {
        ReflectionTestUtils.setField((Object)this.MigrationResource, (String)"modelVersion", (Object)"2.0");
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.MigrationResource).build();
    }

    @Test
    public void should_return_artifact_status_when_migration_required() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.10.0").withPreviousDesignerVersion("1.9.0").build();
        Widget widget = WidgetBuilder.aWidget().id("myWidget").designerVersion("1.10.0").previousDesignerVersion("1.9.0").build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)page);
        String resultType = result.andReturn().getResponse().getContentType();
        Assert.assertNotEquals((Object)resultType, null);
        Assert.assertTrue((boolean)resultType.startsWith(MediaType.APPLICATION_JSON.toString()));
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
        result = this.postStatusRequest((DesignerArtifact)widget);
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)PageBuilder.aPage().withId("myPage").withName("myPage").withDesignerVersion("1.10.0").build());
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(true, true));
        result = this.getStatusRequestById("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
        Widget widget2 = WidgetBuilder.aWidget().id("myWidget").name("myWidget").designerVersion("1.10.0").build();
        Mockito.when((Object)this.widgetRepository.get("myWidget")).thenReturn((Object)widget2);
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget2)).thenReturn((Object)new MigrationStatusReport(true, true));
        result = this.getStatusRequestById("widget", "myWidget");
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_artifact_status_when_no_migration_required() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Widget widget = WidgetBuilder.aWidget().id("myWidget").modelVersion("2.0").build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)page);
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
        result = this.postStatusRequest((DesignerArtifact)widget);
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
        Page page2 = PageBuilder.aPage().withId("myPage").withName("myPage").isMigration(false).withModelVersion("2.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page2);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page2)).thenReturn((Object)new MigrationStatusReport(true, false));
        result = this.getStatusRequestById("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
        Widget widget2 = WidgetBuilder.aWidget().id("myWidget").name("myWidget").isMigration(false).designerVersion("2.0").build();
        Mockito.when((Object)this.widgetRepository.get("myWidget")).thenReturn((Object)widget2);
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget2)).thenReturn((Object)new MigrationStatusReport(true, false));
        result = this.getStatusRequestById("widget", "myWidget");
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_artifact_status_when_not_compatible_required() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.1").build();
        Widget widget = WidgetBuilder.aWidget().id("myWidget").modelVersion("2.1").build();
        ResultActions result = this.postStatusRequest((DesignerArtifact)page);
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
        result = this.postStatusRequest((DesignerArtifact)widget);
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)PageBuilder.aPage().withId("myPage").withName("myPage").isCompatible(false).isMigration(false).withModelVersion("2.1").build());
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(false, false));
        result = this.getStatusRequestById("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
        Mockito.when((Object)this.widgetRepository.get("myWidget")).thenReturn((Object)WidgetBuilder.aWidget().id("myWidget").name("myWidget").isCompatible(false).isMigration(false).designerVersion("2.1").build());
        Mockito.when((Object)this.widgetRepository.get("myWidget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget)).thenReturn((Object)new MigrationStatusReport(false, false));
        result = this.getStatusRequestById("widget", "myWidget");
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_bad_request_when_invalid_artifact_json() throws Exception {
        this.postStatusBadRequest();
    }

    @Test
    public void should_return_not_found_when_invalid_artifact_id() throws Exception {
        Mockito.when((Object)this.pageRepository.get("invalidPageId")).thenThrow(new Throwable[]{new NotFoundException()});
        this.getStatusRequestByIdInvalid("page", "invalidPageId");
        Mockito.when((Object)this.widgetRepository.get("invalidWidgetId")).thenThrow(new Throwable[]{new NotFoundException()});
        this.getStatusRequestByIdInvalid("widget", "invalidWidgetId");
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_to_migrate() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(true, true));
        ResultActions result = this.getStatusRequestByIdRecursive("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(true, true), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_not_compatible() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(false, false));
        ResultActions result = this.getStatusRequestByIdRecursive("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(false, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    @Test
    public void should_return_correct_migration_status_when_embedded_artifact_not_to_migrate() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("2.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)new MigrationStatusReport(true, false));
        ResultActions result = this.getStatusRequestByIdRecursive("page", "myPage");
        Assert.assertEquals((Object)this.getStatusReport(true, false), (Object)result.andReturn().getResponse().getContentAsString());
    }

    private ResultActions postStatusRequest(DesignerArtifact artifact) throws Exception {
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/migration/status", (Object[])new Object[0]).contentType("application/json").content(RestControllerUtil.convertObjectToJsonBytes(artifact))).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void postStatusBadRequest() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/migration/status", (Object[])new Object[0]).contentType("application/json").content("{\"id\":\"test\"\"name\":\"test\",\"rows\":[],\"assets\":[],\"type\" : \"page\"}")).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    private ResultActions getStatusRequestById(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s", artifactType, artifactId);
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private ResultActions getStatusRequestByIdRecursive(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s?recursive=true", artifactType, artifactId);
        return this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void getStatusRequestByIdInvalid(String artifactType, String artifactId) throws Exception {
        String url = String.format("/rest/migration/status/%s/%s", artifactType, artifactId);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private String getStatusReport(boolean compatible, boolean migration) {
        return new MigrationStatusReport(compatible, migration).toString();
    }

    @Test
    public void should_return_200_when_page_migration_is_done_on_success() throws Exception {
        Page pageToMigrate = PageBuilder.aPage().withId("my-page-to-migrate").withName("page-name").build();
        Mockito.when((Object)this.pageRepository.get("my-page-to-migrate")).thenReturn((Object)pageToMigrate);
        Mockito.when((Object)this.pageService.migrateWithReport((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationResult((Object)pageToMigrate, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "my-page-to-migrate"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/my-page-to-migrate", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageService)Mockito.verify((Object)this.pageService)).migrateWithReport((Identifiable)pageToMigrate);
    }

    @Test
    public void should_return_200_when_migration_is_finished_with_warning() throws Exception {
        Page pageToMigrate = PageBuilder.aPage().withId("my-page-to-migrate").withName("page-name").build();
        Mockito.when((Object)this.pageRepository.get("my-page-to-migrate")).thenReturn((Object)pageToMigrate);
        Mockito.when((Object)this.pageService.migrateWithReport((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationResult((Object)pageToMigrate, Collections.singletonList(new MigrationStepReport(MigrationStatus.WARNING, "my-page-to-migrate"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/my-page-to-migrate", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((PageService)Mockito.verify((Object)this.pageService)).migrateWithReport((Identifiable)pageToMigrate);
    }

    @Test
    public void should_return_500_when_an_error_occurs_during_page_migration() throws Exception {
        Page pageToMigrate = PageBuilder.aPage().withId("my-page-to-migrate").withDesignerVersion("1.1.9").withName("page-name").build();
        Mockito.when((Object)this.pageRepository.get("my-page-to-migrate")).thenReturn((Object)pageToMigrate);
        Mockito.when((Object)this.pageService.migrateWithReport((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationResult((Object)pageToMigrate, Collections.singletonList(new MigrationStepReport(MigrationStatus.ERROR, "my-page-to-migrate"))));
        Mockito.when((Object)this.pageService.getStatus((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationStatusReport(true, true));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/my-page-to-migrate", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(500));
        ((PageService)Mockito.verify((Object)this.pageService)).migrateWithReport((Identifiable)pageToMigrate);
    }

    @Test
    public void should_return_200_when_widget_migration_is_done_on_success() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.migrateWithReport((Identifiable)widget)).thenReturn((Object)new MigrationResult((Object)widget, Collections.singletonList(new MigrationStepReport(MigrationStatus.SUCCESS, "my-widget"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/my-widget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateWithReport((Identifiable)widget);
    }

    @Test
    public void should_return_200_when_widget_migration_is_finish_with_warning() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.migrateWithReport((Identifiable)widget)).thenReturn((Object)new MigrationResult((Object)widget, Collections.singletonList(new MigrationStepReport(MigrationStatus.WARNING, "my-widget"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/my-widget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateWithReport((Identifiable)widget);
    }

    @Test
    public void should_return_500_when_an_error_occurs_during_widget_migration() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").custom().build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.migrateWithReport((Identifiable)widget)).thenReturn((Object)new MigrationResult((Object)widget, Collections.singletonList(new MigrationStepReport(MigrationStatus.ERROR, "my-widget"))));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/my-widget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(500));
        ((WidgetService)Mockito.verify((Object)this.widgetService)).migrateWithReport((Identifiable)widget);
    }

    @Test
    public void should_return_404_when_migration_is_trigger_but_page_id_doesnt_exist() throws Exception {
        Mockito.when((Object)this.pageRepository.get("unknownPage")).thenThrow(new Throwable[]{new NotFoundException()});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/unknownPage", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void should_return_404_when_migration_is_trigger_but_widget_id_doesnt_exist() throws Exception {
        Mockito.when((Object)this.widgetRepository.get("unknownWidget")).thenThrow(new Throwable[]{new NotFoundException()});
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/unknownWidget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().is(404));
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_page_is_incompatible() throws Exception {
        Page pageToMigrate = PageBuilder.aPage().withId("my-page-to-migrate").withModelVersion("3.0").withName("page-name").isCompatible(false).build();
        Mockito.when((Object)this.pageRepository.get("my-page-to-migrate")).thenReturn((Object)pageToMigrate);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationStatusReport(false, false));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/my-page-to-migrate", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"Artifact is incompatible with actual version\",\"status\":\"incompatible\",\"elementId\":\"my-page-to-migrate\",\"migrationStepReport\":[]}");
        ((PageService)Mockito.verify((Object)this.pageService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)pageToMigrate);
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_page_not_needed_migration() throws Exception {
        Page pageToMigrate = PageBuilder.aPage().withId("my-page-to-migrate").withModelVersion("2.0.").withName("page-name").build();
        Mockito.when((Object)this.pageRepository.get("my-page-to-migrate")).thenReturn((Object)pageToMigrate);
        Mockito.when((Object)this.pageService.getStatus((Identifiable)pageToMigrate)).thenReturn((Object)new MigrationStatusReport(true, false));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/page/my-page-to-migrate", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"No migration is needed\",\"status\":\"none\",\"elementId\":\"my-page-to-migrate\",\"migrationStepReport\":[]}");
        ((PageService)Mockito.verify((Object)this.pageService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)pageToMigrate);
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_widget_version_is_incompatible() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").modelVersion("3.0").custom().isCompatible(false).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget)).thenReturn((Object)new MigrationStatusReport(false, true));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/my-widget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"Artifact is incompatible with actual version\",\"status\":\"incompatible\",\"elementId\":\"my-widget\",\"migrationStepReport\":[]}");
        ((WidgetService)Mockito.verify((Object)this.widgetService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)widget);
    }

    @Test
    public void should_not_process_migration_and_return_none_status_when_widget_not_needed_migration() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("my-widget").modelVersion("2.0").custom().isMigration(false).build();
        Mockito.when((Object)this.widgetRepository.get("my-widget")).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget)).thenReturn((Object)new MigrationStatusReport(true, false));
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/rest/migration/widget/my-widget", (Object[])new Object[0]).contentType("application/json")).andExpect(MockMvcResultMatchers.status().isOk()).andReturn();
        Assert.assertEquals((Object)result.getResponse().getContentAsString(), (Object)"{\"comments\":\"No migration is needed\",\"status\":\"none\",\"elementId\":\"my-widget\",\"migrationStepReport\":[]}");
        ((WidgetService)Mockito.verify((Object)this.widgetService, (VerificationMode)Mockito.never())).migrateWithReport((Identifiable)widget);
    }
}

