/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.File;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.bonitasoft.web.designer.controller.export.steps.HtmlExportStep;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.HtmlGenerator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@RunWith(value=MockitoJUnitRunner.class)
public class HtmlExportStepTest {
    @Mock
    private HtmlGenerator htmlGenerator;
    @Mock
    private ServletContext servletContext;
    @InjectMocks
    private HtmlExportStep step;
    @Mock
    private Zipper zipper;
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private Resource resource;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.htmlGenerator.generateHtml((Previewable)Matchers.any(Page.class))).thenReturn((Object)"");
        Mockito.when((Object)this.resource.getURI()).thenReturn((Object)new File("src/test/resources/generator").toURI());
        Mockito.when((Object)this.resourceLoader.getResource(Matchers.anyString())).thenReturn((Object)this.resource);
    }

    @Test
    public void should_export_webapp_generator_folder() throws Exception {
        this.step.execute(this.zipper, PageBuilder.aPage().build());
        ((Zipper)Mockito.verify((Object)this.zipper)).addDirectoryToZip(Paths.get(new File("src/test/resources/generator").toURI()), Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, "resources");
    }

    @Test
    public void should_export_generated_html() throws Exception {
        Mockito.when((Object)this.htmlGenerator.generateHtml((Previewable)Matchers.any(Page.class))).thenReturn((Object)"foobar");
        this.step.execute(this.zipper, PageBuilder.aPage().build());
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip("foobar".getBytes(), "resources/index.html");
    }
}

