/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ImportReportBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.importer.ArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PathImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PathImporterTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    @Mock
    private ArtifactImporter importer;
    @Mock
    private ImportStore importStore;
    @InjectMocks
    private PathImporter pathImporter;
    private Path unzipedPath;

    @Before
    public void setUp() throws Exception {
        this.unzipedPath = this.tempDir.newFolderPath("unzipedPath");
        this.pathImporter = new PathImporter(this.importStore);
    }

    private Import aMockedImport() {
        Import anImport = new Import(this.importer, "import-uuid", this.unzipedPath);
        Mockito.when((Object)this.importStore.store(this.importer, this.unzipedPath)).thenReturn((Object)anImport);
        return anImport;
    }

    @Test
    public void should_import_zip_file() throws Exception {
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage()).withStatus(ImportReport.Status.IMPORTED).build();
        Mockito.when((Object)this.importer.doImport(this.aMockedImport())).thenReturn((Object)expectedReport);
        ImportReport report = this.pathImporter.importFromPath(this.unzipedPath, this.importer);
        Assertions.assertThat((Object)expectedReport).isEqualTo((Object)report);
    }

    @Test
    public void should_remove_import_from_store_if_report_status_is_imported() throws Exception {
        Import anImport = this.aMockedImport();
        Mockito.when((Object)this.importer.doImport(anImport)).thenReturn((Object)ImportReportBuilder.anImportReportFor(PageBuilder.aPage()).withStatus(ImportReport.Status.IMPORTED).build());
        this.pathImporter.importFromPath(this.unzipedPath, this.importer);
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
    }

    @Test
    public void should_remove_import_from_store_if_an_error_occurs_when_importing() throws Exception {
        Import anImport = this.aMockedImport();
        Mockito.when((Object)this.importer.doImport(anImport)).thenThrow(new Class[]{ImportException.class});
        try {
            this.pathImporter.importFromPath(this.unzipedPath, this.importer);
            Assertions.failBecauseExceptionWasNotThrown(ImportException.class);
        }
        catch (Exception e) {
            ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
        }
    }

    @Test
    public void should_force_import_of_zip_file() throws Exception {
        Import anImport = this.aMockedImport();
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage()).withStatus(ImportReport.Status.IMPORTED).build();
        Mockito.when((Object)this.importer.forceImport(anImport)).thenReturn((Object)expectedReport);
        ImportReport report = this.pathImporter.forceImportFromPath(this.unzipedPath, this.importer);
        Assertions.assertThat((Object)expectedReport).isEqualTo((Object)report);
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
    }

    @Test(expected=ImportException.class)
    public void should_throw_import_exception_when_an_import_error_occurs() throws Exception {
        Mockito.when((Object)this.importStore.store(this.importer, this.unzipedPath)).thenReturn((Object)new Import(this.importer, "a-uuid", this.unzipedPath));
        ((ArtifactImporter)Mockito.doThrow((Throwable)new ImportException(ImportException.Type.PAGE_NOT_FOUND, "an Error message")).when((Object)this.importer)).doImport((Import)Matchers.any(Import.class));
        this.pathImporter.importFromPath(this.unzipedPath, this.importer);
    }
}

