/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.generator.mapping.ContractInputToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.ContractToContainerMapper;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Test;

public class ContractToContainerMapperTest {
    private JacksonObjectMapper objectMapper = new DesignerConfig().objectMapperWrapper();

    @Test
    public void should_set_value_relative_to_business_data_in_edit_mode() throws Exception {
        ContractToContainerMapper contractToContainerMapper = this.makeContractToContainerMapper();
        Container container = contractToContainerMapper.create(ContractBuilder.aSimpleContractWithDataRef((EditMode)EditMode.EDIT));
        Container formContainer = (Container)((List)container.getRows().get(1)).get(0);
        List firstRow = (List)formContainer.getRows().get(0);
        Component firstNameInput = (Component)firstRow.get(0);
        PropertyValue pValue = (PropertyValue)firstNameInput.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"employee.firstName");
        List fourthRow = (List)formContainer.getRows().get(4);
        Container managerContainer = (Container)fourthRow.get(0);
        Element managerfirstName = (Element)((List)managerContainer.getRows().get(0)).get(0);
        pValue = (PropertyValue)managerfirstName.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"employee_manager.firstName");
        List sixthRow = (List)formContainer.getRows().get(6);
        Container addressContainer = (Container)sixthRow.get(0);
        PropertyValue repeatedCollection = (PropertyValue)addressContainer.getPropertyValues().get("repeatedCollection");
        Assertions.assertThat((String)repeatedCollection.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollection.getValue()).isEqualTo((Object)"employee_addresses");
        Component streetInput = (Component)((List)addressContainer.getRows().get(0)).get(0);
        pValue = (PropertyValue)streetInput.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"$item.street");
    }

    @Test
    public void should_set_value_relative_to_formInput_in_create_mode() throws Exception {
        ContractToContainerMapper contractToContainerMapper = this.makeContractToContainerMapper();
        Container container = contractToContainerMapper.create(ContractBuilder.aSimpleContractWithDataRef((EditMode)EditMode.CREATE));
        Container formContainer = (Container)((List)container.getRows().get(1)).get(0);
        List firstRow = (List)formContainer.getRows().get(0);
        Component firstNameInput = (Component)firstRow.get(0);
        PropertyValue pValue = (PropertyValue)firstNameInput.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"formInput.employeeInput.firstName");
        List fourthRow = (List)formContainer.getRows().get(4);
        Container managerContainer = (Container)fourthRow.get(0);
        Element managerfirstName = (Element)((List)managerContainer.getRows().get(0)).get(0);
        pValue = (PropertyValue)managerfirstName.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"formInput.employeeInput.manager.firstName");
        List sixthRow = (List)formContainer.getRows().get(6);
        Container addressContainer = (Container)sixthRow.get(0);
        PropertyValue repeatedCollection = (PropertyValue)addressContainer.getPropertyValues().get("repeatedCollection");
        Assertions.assertThat((String)repeatedCollection.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollection.getValue()).isEqualTo((Object)"formInput.employeeInput.addresses");
        Component streetInput = (Component)((List)addressContainer.getRows().get(0)).get(0);
        pValue = (PropertyValue)streetInput.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"$item.street");
    }

    @Test
    public void should_create_a_Select_widget_for_aggregated_dataRef() throws Exception {
        ContractToContainerMapper contractToContainerMapper = this.makeContractToContainerMapper();
        Container container = contractToContainerMapper.create(ContractBuilder.aContractWithDataRefAndAggregation((EditMode)EditMode.EDIT));
        Container formContainer = (Container)((List)container.getRows().get(1)).get(0);
        List fourthRow = (List)formContainer.getRows().get(3);
        Component managerSelect = (Component)fourthRow.get(0);
        Assertions.assertThat((String)managerSelect.getId()).isEqualTo((Object)"pbSelect");
        PropertyValue pValue = (PropertyValue)managerSelect.getPropertyValues().get("availableValues");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"expression");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"employee_query");
        pValue = (PropertyValue)managerSelect.getPropertyValues().get("value");
        Assertions.assertThat((String)pValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)pValue.getValue()).isEqualTo((Object)"employee.manager");
    }

    private ContractToContainerMapper makeContractToContainerMapper() {
        return new ContractToContainerMapper(new ContractInputToWidgetMapper(new DimensionFactory(), this.objectMapper));
    }
}

