/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PropertyValueBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.generator.mapping.ContractInputToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.ContractToContainerMapper;
import org.bonitasoft.web.designer.generator.mapping.ContractToPageMapper;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.generator.mapping.FormScope;
import org.bonitasoft.web.designer.generator.mapping.data.BusinessQueryDataFactory;
import org.bonitasoft.web.designer.generator.parametrizedWidget.Alignment;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ButtonAction;
import org.bonitasoft.web.designer.generator.parametrizedWidget.TextWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.TitleWidget;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.contract.Contract;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContractToPageMapperTest {
    JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    private ContractInputToWidgetMapper contractToWidgetMapper = new ContractInputToWidgetMapper(new DimensionFactory(), this.objectMapper);
    ContractToContainerMapper contractToContainerMapper = new ContractToContainerMapper(this.contractToWidgetMapper);

    @Test
    public void visit_a_contract_when_creating_a_page() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.TASK);
        Assertions.assertThat((List)this.getTaskFormContainerContent(page).getRows()).hasSize(6);
    }

    private ContractToPageMapper makeContractToPageMapper() {
        return new ContractToPageMapper(this.contractToWidgetMapper, this.contractToContainerMapper, this.objectMapper, new DimensionFactory(), new BusinessQueryDataFactory());
    }

    @Test
    public void should_create_a_page_with_the_form_type() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Assertions.assertThat((String)page.getType()).isEqualTo((Object)"form");
    }

    @Test
    public void should_create_a_page_with_a_form_container() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Assertions.assertThat((List)page.getRows()).hasSize(2);
        Assertions.assertThat(((List)page.getRows().get(1)).get(0)).isInstanceOf(FormContainer.class);
    }

    @Test
    public void create_a_page_with_form_input_and_output() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"formInput", (Object)VariableBuilder.aJSONVariable().value(this.objectMapper.prettyPrint("{\"names\":[]}")).build())});
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"formOutput", (Object)VariableBuilder.anExpressionVariable().value("return {\n\tnames: $data.formInput.names\n}").build())});
    }

    @Test
    public void create_a_page_with_a_context_url_data_for_task() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"context", (Object)VariableBuilder.anURLVariable().value("../API/bpm/userTask/{{taskId}}/context").build())});
    }

    @Test
    public void create_a_page_with_a_id_expression_data_for_task_scope() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"taskId", (Object)VariableBuilder.aUrlParameterVariable().value("id").build())});
    }

    @Test
    public void create_a_page_without_a_context_url_data_for_process_scope() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.PROCESS);
        Assertions.assertThat((Map)page.getVariables()).doesNotContain(new Map.Entry[]{Assertions.entry((Object)"context", (Object)VariableBuilder.anURLVariable().value("/bonita/API/bpm/userTask/{{taskId}}/context").build())});
    }

    @Test
    public void create_a_page_without_an_id_expression_data_for_process() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.PROCESS);
        Assertions.assertThat((Map)page.getVariables()).doesNotContain(new Map.Entry[]{Assertions.entry((Object)"taskId", (Object)VariableBuilder.aUrlParameterVariable().value("id").build())});
    }

    @Test
    public void create_a_page_without_output_data_for_overview_scope() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContract().build(), FormScope.OVERVIEW);
        Assertions.assertThat((Map)page.getVariables()).isEmpty();
    }

    @Test
    public void create_a_page_with_a_submit_button_sending_contract() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithMultipleInput(), FormScope.TASK);
        Component submitButon = (Component)((List)this.getTaskFormContainerContent(page).getRows().get(3)).get(0);
        Assertions.assertThat((String)submitButon.getId()).isEqualTo((Object)"pbButton");
        Assertions.assertThat((Map)submitButon.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"dataToSend", (Object)PropertyValueBuilder.anExpressionPropertyValue("formOutput")), Assertions.entry((Object)"action", (Object)PropertyValueBuilder.aConstantPropertyValue(ButtonAction.SUBMIT_TASK.getValue())), Assertions.entry((Object)"targetUrlOnSuccess", (Object)PropertyValueBuilder.aInterpolationPropertyValue("/bonita"))});
    }

    @Test
    public void create_a_page_and_fetch_associated_task() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"task", (Object)VariableBuilder.anURLVariable().value("../API/bpm/userTask/{{taskId}}").build())});
    }

    @Test
    public void create_a_page_display_task_name() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        TitleWidget title = new TitleWidget();
        title.setLevel("Level 1");
        title.setText("{{ task.displayName }}");
        title.setAlignment(Alignment.CENTER);
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.TASK);
        Assertions.assertThat((boolean)((Element)((List)this.grabTaskInformation(page).getRows().get(0)).get(0)).getPropertyValues().containsKey("class")).isFalse();
        Assertions.assertThat(((List)this.grabTaskInformation(page).getRows().get(0)).get(0)).isEqualToIgnoringGivenFields((Object)title.toComponent(new DimensionFactory()), new String[]{"reference"});
    }

    @Test
    public void create_a_page_display_task_description() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        TextWidget description = new TextWidget();
        description.setText("{{ task.displayDescription }}");
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContract(), FormScope.TASK);
        Assertions.assertThat(((List)this.grabTaskInformation(page).getRows().get(1)).get(0)).isEqualToIgnoringGivenFields((Object)description.toComponent(new DimensionFactory()), new String[]{"reference"});
    }

    @Test
    public void should_create_an_empty_container_when_contract_is_empty_and_scope_is_overview() throws Exception {
        Contract anEmptyContract = ContractBuilder.aContract().build();
        Page page = this.makeContractToPageMapper().createFormPage("myPage", anEmptyContract, FormScope.OVERVIEW);
        Container container = (Container)((List)page.getRows().get(0)).get(0);
        Assertions.assertThat((List)((List)container.getRows().get(0))).isEqualTo(new ArrayList());
    }

    @Test
    public void should_create_a_page_with_a_business_data_when_contract_contains_data_reference_on_a_task() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContractWithDataRef((EditMode)EditMode.EDIT), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"employee", (Object)VariableBuilder.anURLVariable().value("../{{context.employee_ref.link}}").build())});
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"employee_addresses", (Object)VariableBuilder.anURLVariable().value("{{employee|lazyRef:'addresses'}}").build())});
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"employee_manager", (Object)VariableBuilder.anURLVariable().value("{{employee|lazyRef:'manager'}}").build())});
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"employee_manager_addresses", (Object)VariableBuilder.anURLVariable().value("{{employee_manager|lazyRef:'addresses'}}").build())});
        Assertions.assertThat((Map)page.getVariables()).doesNotContain(new Map.Entry[]{Assertions.entry((Object)"employee_addresses_country", (Object)VariableBuilder.anURLVariable().value("{{employee_addresses|lazyRef:'country'}}").build())});
    }

    @Test
    public void should_create_a_page_with_a_query_varaible_when_contract_contains_data_reference_with_aggregation() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aContractWithDataRefAndAggregation((EditMode)EditMode.EDIT), FormScope.TASK);
        Assertions.assertThat((Map)page.getVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"employee_query", (Object)VariableBuilder.anURLVariable().value("../API/bdm/businessData/org.test.Employee?q=find&p=0&c=99").build())});
    }

    @Test
    public void should_create_a_page_without_formInput_when_contract_contains__only_data_reference_on_a_task() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContractWithDataRef((EditMode)EditMode.EDIT), FormScope.TASK);
        Assertions.assertThat(page.getVariables().keySet()).doesNotContain((Object[])new String[]{"formInput"});
    }

    @Test
    public void should_create_a_Text_widget_for_submit_error() throws Exception {
        ContractToPageMapper contractToPageMapper = this.makeContractToPageMapper();
        Page page = contractToPageMapper.createFormPage("myPage", ContractBuilder.aSimpleContractWithDataRef((EditMode)EditMode.EDIT), FormScope.TASK);
        Assertions.assertThat(page.getVariables().keySet()).contains((Object[])new String[]{"submit_errors_list"});
        FormContainer formContainer = (FormContainer)((List)page.getRows().get(1)).get(0);
        Component submitButton = (Component)((List)formContainer.getContainer().getRows().get(2)).get(0);
        Assertions.assertThat((String)submitButton.getId()).isEqualTo((Object)"pbButton");
        PropertyValue dataFromErrorProperty = (PropertyValue)submitButton.getPropertyValues().get("dataFromError");
        Assertions.assertThat((Object)dataFromErrorProperty).isNotNull();
        Assertions.assertThat((Object)dataFromErrorProperty.getValue()).isEqualTo((Object)"formOutput._submitError");
        Component errorText = (Component)((List)formContainer.getContainer().getRows().get(3)).get(0);
        Assertions.assertThat((String)errorText.getId()).isEqualTo((Object)"pbText");
        PropertyValue hiddenProperty = (PropertyValue)errorText.getPropertyValues().get("hidden");
        Assertions.assertThat((Object)hiddenProperty).isNotNull();
        Assertions.assertThat((Object)hiddenProperty.getValue()).isEqualTo((Object)"!formOutput._submitError.message");
    }

    private Container grabTaskInformation(Page page) {
        return (Container)((List)page.getRows().get(0)).get(0);
    }

    public Container getTaskFormContainerContent(Page page) {
        return ((FormContainer)((List)page.getRows().get(1)).get(0)).getContainer();
    }
}

