/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.parametrizedWidget;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.generator.mapping.dataManagement.NodeBusinessObjectInput;
import org.bonitasoft.web.designer.generator.parametrizedWidget.AbstractParametrizedWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.DatePickerWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.InputWidget;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParameterConstants;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ParametrizedDataManagementWidgetFactory;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParametrizedDataManagementWidgetFactoryTest
implements ParameterConstants {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private ParametrizedDataManagementWidgetFactory elementFactory;
    private NodeBusinessObjectInput nodeInput;
    private DimensionFactory dimensionFactory;

    @Before
    public void init() {
        this.elementFactory = new ParametrizedDataManagementWidgetFactory();
        this.dimensionFactory = new DimensionFactory();
        this.nodeInput = new NodeBusinessObjectInput("com.company.model.person");
        this.nodeInput.setMultiple(true);
        this.nodeInput.setPageDataName("person");
    }

    @Test
    public void should_create_read_only_input_widget_when_leaf_is_readOnly() {
        LeafContractInput input = new LeafContractInput("LastName", String.class);
        input.setReadonly(true);
        AbstractParametrizedWidget widget = this.elementFactory.createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isReadOnly()).isEqualTo(true);
        Assertions.assertThat((String)((InputWidget)widget).getLabel()).isEqualTo((Object)"Last Name");
    }

    @Test
    public void should_set_input_widget_value_with_global_variable_name_from_parent_input() {
        LeafContractInput input = new LeafContractInput("lastName", String.class);
        input.setParent((ContractInput)this.nodeInput);
        input.setReadonly(true);
        input.setMandatory(false);
        AbstractParametrizedWidget widget = this.elementFactory.createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isReadOnly()).isEqualTo(true);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isEqualTo(false);
        Assertions.assertThat((String)((InputWidget)widget).getValue()).isEqualTo((Object)(this.nodeInput.getPageDataNameSelected() + "." + input.getName()));
        Assertions.assertThat((String)((InputWidget)widget).getLabel()).isEqualTo((Object)"Last Name");
    }

    @Test
    public void should_set_dateTime_widget_value_with_global_variable_name_from_parent_input() {
        LeafContractInput input = new LeafContractInput("birthday", LocalDate.class);
        input.setParent((ContractInput)this.nodeInput);
        input.setReadonly(true);
        AbstractParametrizedWidget widget = this.elementFactory.createParametrizedWidget((ContractInput)input);
        Assertions.assertThat((Object)widget).isInstanceOf(DatePickerWidget.class);
        Assertions.assertThat((boolean)((DatePickerWidget)widget).isReadOnly()).isEqualTo(true);
        Assertions.assertThat((String)((DatePickerWidget)widget).getValue()).isEqualTo((Object)(this.nodeInput.getPageDataNameSelected() + "." + input.getName()));
        Assertions.assertThat((String)((InputWidget)widget).getLabel()).isEqualTo((Object)"Birthday");
    }

    @Test
    public void create_a_details_container_with_hidden_property() {
        NodeBusinessObjectInput input = new NodeBusinessObjectInput("com.company.model.person");
        input.setPageDataName("person");
        Container container = this.elementFactory.createDetailsWidgetContainer(this.dimensionFactory, input);
        Assertions.assertThat((String)container.getDescription()).isNotEmpty();
        Assertions.assertThat((Object)((PropertyValue)container.getPropertyValues().get("hidden")).getValue()).isEqualTo((Object)"!person_selected");
        Assertions.assertThat((Integer)((Integer)container.getDimension().get("xs"))).isEqualTo(11);
    }

    @Test
    public void create_a_spacing_container() {
        NodeBusinessObjectInput input = new NodeBusinessObjectInput("com.company.model.person");
        input.setPageDataName("person");
        Container container = this.elementFactory.createSpacingContainer(this.dimensionFactory, input);
        Assertions.assertThat((Integer)((Integer)container.getDimension().get("xs"))).isEqualTo(1);
        Assertions.assertThat((List)((List)container.getRows().get(0))).isEqualTo(Collections.emptyList());
        Assertions.assertThat((Object)((PropertyValue)container.getPropertyValues().get("hidden")).getValue()).isEqualTo((Object)"!person_selected");
    }

    @Test
    public void should_set_required_false_for_non_mandatory_contract_input() {
        LeafContractInput aInputWidget = ContractInputBuilder.aStringContractInput((String)"myString");
        aInputWidget.setMandatory(false);
        AbstractParametrizedWidget widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        aInputWidget.setMandatory(true);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isTrue();
        aInputWidget.setMultiple(true);
        aInputWidget.setMandatory(false);
        widget = this.createFactory().createParametrizedWidget((ContractInput)aInputWidget);
        Assertions.assertThat((Object)widget).isInstanceOf(InputWidget.class);
        Assertions.assertThat((boolean)((InputWidget)widget).isRequired()).isTrue();
        Assertions.assertThat((String)((InputWidget)widget).getValue()).isEqualTo((Object)"$item");
    }

    private ParametrizedDataManagementWidgetFactory createFactory() {
        return new ParametrizedDataManagementWidgetFactory();
    }
}

