/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.AbstractLoader;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LiveRepositoryUpdateTest {
    JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    @Mock
    JsonFileBasedPersister<Page> persister;
    JsonFileBasedLoader<Page> loader = new JsonFileBasedLoader(this.objectMapper, Page.class);
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Mock
    BeanValidator beanValidator;
    PageRepository repository;

    @Before
    public void setUp() throws Exception {
        this.repository = new PageRepository(this.folder.toPath(), this.persister, this.loader, this.beanValidator, (Watcher)Mockito.mock(Watcher.class));
    }

    @Test
    public void should_migrate_a_page() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.singletonList(migration));
        Page page = this.createPage("2.0");
        Optional<MigrationStepReport> stepReport = Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "pageJson"));
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(stepReport);
        liveRepositoryUpdate.migrate();
        page.setModelVersion("2.1");
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).save(this.folder.getRoot().toPath().resolve("pageJson"), (Identifiable)page);
    }

    @Test
    public void should_not_migrate_file_which_are_not_json() throws Exception {
        Migration migration = (Migration)Mockito.mock(Migration.class);
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.singletonList(migration));
        this.folder.newFile("whatever");
        liveRepositoryUpdate.migrate();
        ((Migration)Mockito.verify((Object)migration, (VerificationMode)Mockito.never())).migrate((DesignerArtifact)Matchers.any(Page.class));
    }

    @Test
    public void should_not_save_an_artifact_already_migrated() throws Exception {
        Migration migration = new Migration("1.0.2", new MigrationStep[]{(MigrationStep)Mockito.mock(MigrationStep.class)});
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.singletonList(migration));
        this.createPage("1.0.2");
        liveRepositoryUpdate.migrate();
        ((JsonFileBasedPersister)Mockito.verify(this.persister, (VerificationMode)Mockito.never())).save((Path)Matchers.any(Path.class), (Identifiable)Matchers.any(Page.class));
    }

    @Test
    public void should_exclude_assets() throws Exception {
        Migration migration = (Migration)Mockito.mock(Migration.class);
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.singletonList(migration));
        this.createPage("1.0.0");
        this.folder.newFolder(new String[]{"pageJson", "assets"});
        this.folder.newFile("pageJson/assets/whatever.json");
        liveRepositoryUpdate.migrate();
        ((Migration)Mockito.verify((Object)migration, (VerificationMode)Mockito.only())).migrate((DesignerArtifact)Matchers.any(Page.class));
    }

    @Test
    public void should_be_refresh_repository_index_json_on_start() throws Exception {
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.EMPTY_LIST);
        this.createPage("1.7.25");
        liveRepositoryUpdate.start();
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).updateMetadata((Path)Matchers.any(Path.class), (Identifiable)Matchers.any(Page.class));
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).saveInIndex((Path)Matchers.any(Path.class), (Identifiable)Matchers.any(Page.class));
    }

    @Test
    public void should_order_LiveRepositoryUpdate() throws Exception {
        LiveRepositoryUpdate pageLiveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, this.loader, Collections.EMPTY_LIST);
        WidgetRepository wRepo = new WidgetRepository(this.folder.toPath(), (JsonFileBasedPersister)Mockito.mock(JsonFileBasedPersister.class), (JsonFileBasedLoader)Mockito.mock(WidgetFileBasedLoader.class), this.beanValidator, (Watcher)Mockito.mock(Watcher.class));
        LiveRepositoryUpdate widgetLiveRepositoryUpdate = new LiveRepositoryUpdate((Repository)wRepo, (AbstractLoader)Mockito.mock(WidgetFileBasedLoader.class), Collections.EMPTY_LIST);
        ArrayList<LiveRepositoryUpdate> liveRepoList = new ArrayList<LiveRepositoryUpdate>();
        liveRepoList.add(pageLiveRepositoryUpdate);
        liveRepoList.add(widgetLiveRepositoryUpdate);
        Assertions.assertThat(liveRepoList).containsExactly((Object[])new LiveRepositoryUpdate[]{pageLiveRepositoryUpdate, widgetLiveRepositoryUpdate});
        Assertions.assertThat(liveRepoList.stream().sorted().collect(Collectors.toList())).containsExactly((Object[])new LiveRepositoryUpdate[]{widgetLiveRepositoryUpdate, pageLiveRepositoryUpdate});
    }

    private Page createPage(String version) throws IOException {
        this.folder.newFolder("pageJson");
        File pageJson = this.folder.newFile("pageJson/pageJson.json");
        Files.write(pageJson.toPath(), String.format("{ \"id\": \"pageJson\", \"modelVersion\": \"%s\" }", version).getBytes(), new OpenOption[0]);
        return (Page)this.loader.load(pageJson.getParentFile().toPath().resolve(pageJson.getName()));
    }
}

