/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleAddModalContainerPropertiesMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StyleAddModalContainerPropertiesMigrationStepTest {
    @Mock
    private AssetService<Page> pageAssetService;
    @InjectMocks
    private StyleAddModalContainerPropertiesMigrationStep step;

    @Before
    public void setUp() throws Exception {
        this.step = new StyleAddModalContainerPropertiesMigrationStep(this.pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    @Test
    public void should_migrate_style_asset_to_add_new_modal_container_css_classes() throws Exception {
        Asset style = AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css").build();
        String initContent = ".my-content {background: red}";
        Page page = PageBuilder.aPage().withDesignerVersion("1.7.9").withAsset(style).build();
        Mockito.when((Object)this.pageAssetService.getAssetContent((Assetable)page, style)).thenReturn((Object)initContent);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("templates/migration/assets/css/styleAddModalContainerProperties.css");
        String content = initContent.concat(IOUtils.toString((InputStream)is));
        this.step.migrate(page);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, this.expectedAsset("style.css"), content.getBytes());
    }
}

