/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.StyleAssetMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.AssetRepository;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.Repository;
import org.bonitasoft.web.designer.utils.FakePageRepository;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class StyleAssetMigrationStepTest {
    @Mock
    private AssetRepository<Page> assetRepository;
    private PageRepository pageRepository = new FakePageRepository();
    @InjectMocks
    private StyleAssetMigrationStep step;

    @Before
    public void setUp() throws Exception {
        AssetService pageAssetService = new AssetService((Repository)this.pageRepository, this.assetRepository, null, null);
        this.step = new StyleAssetMigrationStep(pageAssetService);
    }

    private Asset expectedAsset(String name) {
        return AssetBuilder.anAsset().withType(AssetType.CSS).withName(name).build();
    }

    private byte[] expectedAssetContent() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("templates/page/assets/css/style.css"));
    }

    @Test
    public void should_add_new_style_asset_to_migrated_pages() throws Exception {
        Page page = PageBuilder.aPage().withDesignerVersion("1.4.7").build();
        this.step.migrate(page);
        Page migratedPage = (Page)this.pageRepository.get(page.getId());
        Assertions.assertThat((Iterable)migratedPage.getAssets()).contains((Object[])new Asset[]{this.expectedAsset("style.css")});
        ((AssetRepository)Mockito.verify(this.assetRepository)).save(page.getId(), this.expectedAsset("style.css"), this.expectedAssetContent());
    }

    @Test
    public void should_add_new_style_asset_with_different_name_while_already_existing() throws Exception {
        Page page = PageBuilder.aPage().withDesignerVersion("1.4.7").withAsset(AssetBuilder.anAsset().withType(AssetType.CSS).withName("style.css")).withAsset(AssetBuilder.anAsset().withType(AssetType.CSS).withName("style1.css")).build();
        this.step.migrate(page);
        Page migratedPage = (Page)this.pageRepository.get(page.getId());
        Assertions.assertThat((Iterable)migratedPage.getAssets()).contains((Object[])new Asset[]{this.expectedAsset("style2.css")});
        ((AssetRepository)Mockito.verify(this.assetRepository)).save(page.getId(), this.expectedAsset("style2.css"), this.expectedAssetContent());
    }
}

