/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.DirectiveFileGenerator;
import org.bonitasoft.web.designer.rendering.DirectivesCollector;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.bonitasoft.web.designer.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DirectivesCollectorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @InjectMocks
    private DirectivesCollector collector;
    @Mock
    private WorkspacePathResolver pathResolver;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private FragmentIdVisitor fragmentIdVisitor;
    @Mock
    private DirectiveFileGenerator directiveFileGenerator;

    @Before
    public void beforeEach() throws IOException {
        Mockito.when((Object)this.pathResolver.getPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath());
        this.collector = new DirectivesCollector(this.pathResolver, this.directiveFileGenerator, this.fragmentIdVisitor, this.fragmentRepository);
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("pages"));
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("pages"));
        Mockito.when((Object)this.pathResolver.getTmpFragmentsRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("fragments"));
        Mockito.when((Object)this.pathResolver.getFragmentsRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), "fragments"));
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("pages"));
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("pages"));
        Mockito.when((Object)this.pathResolver.getTmpFragmentsRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath().resolve("fragments"));
    }

    @Test
    public void should_build_directives_from_the_preview() throws IOException {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.pathResolver.getTmpPagesRepositoryPath()).thenReturn((Object)this.temporaryFolder.toPath());
        Path assets = this.temporaryFolder.toPath().resolve(page.getId()).resolve("js");
        Mockito.when((Object)this.directiveFileGenerator.generateAllDirectivesFilesInOne((Previewable)page, assets)).thenReturn((Object)"widgets-123456.min.js");
        List imports = this.collector.buildUniqueDirectivesFiles((Previewable)page, page.getId());
        Assertions.assertThat((List)imports).containsOnly((Object[])new String[]{"js/widgets-123456.min.js"});
    }

    @Test
    public void should_collect_widgets_directives_from_the_fragment_preview() throws Exception {
        Fragment fragment = FragmentBuilder.aFragment().build();
        Mockito.when((Object)this.directiveFileGenerator.generateAllDirectivesFilesInOne((Previewable)fragment, this.temporaryFolder.toPath().resolve("fragments").resolve(fragment.getId()))).thenReturn((Object)"widgets-654321");
        List imports = this.collector.buildUniqueDirectivesFiles((Previewable)fragment, fragment.getId());
        Assertions.assertThat((List)imports).containsOnly((Object[])new String[]{"widgets-654321"});
    }

    @Test
    public void should_collect_widget_file_directive_and_fragment_file_when_fragment_will_be_use_in_page() throws IOException {
        Page page = PageBuilder.aPage().build();
        Fragment fragment = FragmentBuilder.aFragment().build();
        this.initFileAndMockForPageWhoHasFragment(page, fragment);
        List<String> expected = Arrays.asList("js/widgets-123456.js", "fragments/" + fragment.getId() + "/" + fragment.getId() + ".js");
        List imports = this.collector.buildUniqueDirectivesFiles((Previewable)page, page.getId());
        Assertions.assertThat((List)imports).isEqualTo(expected);
    }

    private void initFileAndMockForPageWhoHasFragment(Page page, Fragment fragment) throws IOException {
        Path pagePathAsset = this.temporaryFolder.toPath().resolve("pages").resolve(page.getId()).resolve("js");
        Path fragmentsPath = this.temporaryFolder.toPath().resolve("fragments").resolve(fragment.getId());
        Mockito.when((Object)this.directiveFileGenerator.generateAllDirectivesFilesInOne((Previewable)page, pagePathAsset)).thenReturn((Object)"widgets-123456.js");
        Mockito.when((Object)this.directiveFileGenerator.generateAllDirectivesFilesInOne((Previewable)fragment, fragmentsPath)).thenReturn((Object)"widgets-654321.js");
        HashSet<String> fragmentIds = new HashSet<String>(Arrays.asList(fragment.getId()));
        Mockito.when((Object)this.fragmentIdVisitor.visit((Previewable)page)).thenReturn(fragmentIds);
        Mockito.when((Object)this.fragmentRepository.getByIds(fragmentIds)).thenReturn(Arrays.asList(fragment));
    }
}

