/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Arrays;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.service.PageMigrationApplyer;
import org.bonitasoft.web.designer.service.PageService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class PageServiceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @Mock
    private PageMigrationApplyer pageMigrationApplyer;
    @Mock
    private PageRepository pageRepository;
    @InjectMocks
    private PageService pageService;

    @Before
    public void setUp() throws Exception {
        this.pageService = new PageService(this.pageRepository, this.pageMigrationApplyer);
        ReflectionTestUtils.setField((Object)this.pageService, (String)"modelVersion", (Object)CURRENT_MODEL_VERSION);
    }

    @Test
    public void should_migrate_found_page_when_get_is_called() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.0").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(true, false));
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).getMigrationStatusDependencies(page);
    }

    @Test
    public void should_not_update_and_save_page_if_no_migration_done() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(true, false));
        Page returnedPage = this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
        Assert.assertEquals((Object)returnedPage.getStatus().isCompatible(), (Object)true);
        Assert.assertEquals((Object)returnedPage.getStatus().isMigration(), (Object)false);
    }

    @Test
    public void should_not_update_and_save_page_if_migration_is_on_error() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.0").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.ERROR)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(true, false));
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
    }

    @Test
    public void should_migrate_page_when_dependencies_need_to_be_migrated() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(true, true));
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
    }

    @Test
    public void should_not_migrate_page_when_page_not_compatible() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("3.0").build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(false, false));
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
    }

    @Test
    public void should_not_migrate_page_when_dependencies_not_compatible() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(false, false));
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
    }

    @Test
    public void should_migrate_page_when_no_artifact_version_is_declared() {
        Page page = PageBuilder.aPage().withId("myPage").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)this.pageRepository.get("myPage")).thenReturn((Object)page);
        Mockito.when((Object)this.pageMigrationApplyer.getMigrationStatusDependencies(page)).thenReturn((Object)new MigrationStatusReport(true, false));
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)Mockito.any(Page.class));
    }
}

