/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.controller.MigrationStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.service.BondsTypesFixer;
import org.bonitasoft.web.designer.service.WidgetMigrationApplyer;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.visitor.WidgetIdVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class WidgetServiceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private BondsTypesFixer bondsTypesFixer;
    @Mock
    private WidgetMigrationApplyer widgetMigrationApplyer;
    @Mock
    private WidgetIdVisitor widgetIdVisitor;
    @InjectMocks
    private WidgetService widgetService;

    @Before
    public void setUp() throws Exception {
        this.widgetService = new WidgetService(this.widgetRepository, Collections.singletonList(this.bondsTypesFixer), this.widgetMigrationApplyer, this.widgetIdVisitor);
        ReflectionTestUtils.setField((Object)this.widgetService, (String)"modelVersion", (Object)CURRENT_MODEL_VERSION);
    }

    @Test
    public void should_fix_bonds_types_on_save() {
        Property constantTextProperty = PropertyBuilder.aProperty().name("text").bond(BondType.CONSTANT).build();
        Property interpolationTextProperty = PropertyBuilder.aProperty().name("text").bond(BondType.INTERPOLATION).build();
        Widget persistedWidget = WidgetBuilder.aWidget().id("labelWidget").modelVersion(CURRENT_MODEL_VERSION).property(constantTextProperty).build();
        Mockito.when((Object)this.widgetRepository.get("labelWidget")).thenReturn((Object)persistedWidget);
        this.widgetService.updateProperty("labelWidget", "text", interpolationTextProperty);
        ((BondsTypesFixer)Mockito.verify((Object)this.bondsTypesFixer)).fixBondsTypes("labelWidget", Collections.singletonList(interpolationTextProperty));
    }

    @Test
    public void should_migrate_found_widget_when_get_is_called() {
        Widget widget = WidgetBuilder.aWidget().id("widget").designerVersion("1.0.0").build();
        Widget widgetMigrated = WidgetBuilder.aWidget().id("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion("1.0.0").build();
        Mockito.when((Object)this.widgetRepository.get("widget")).thenReturn((Object)widget);
        MigrationResult mr = new MigrationResult((Object)widgetMigrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)mr.getArtifact());
    }

    @Test
    public void should_not_update_and_save_widget_if_no_migration_done() {
        Widget widget = WidgetBuilder.aWidget().id("widget").modelVersion(CURRENT_MODEL_VERSION).build();
        Widget widgetMigrated = WidgetBuilder.aWidget().id("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion(CURRENT_MODEL_VERSION).build();
        MigrationResult mr = new MigrationResult((Object)widget, Arrays.asList((MigrationStepReport)Mockito.any(MigrationStepReport.class)));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        Mockito.when((Object)this.widgetRepository.get("widget")).thenReturn((Object)widget);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer, (VerificationMode)Mockito.never())).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)widgetMigrated);
    }

    @Test
    public void should_migrate_all_custom_widget() throws Exception {
        Widget widget1 = WidgetBuilder.aWidget().id("widget1").designerVersion("1.0.0").build();
        Widget widget2 = WidgetBuilder.aWidget().id("widget2").designerVersion("1.0.0").build();
        Widget widget1Migrated = WidgetBuilder.aWidget().id("widget1").designerVersion(CURRENT_MODEL_VERSION).build();
        Widget widget2Migrated = WidgetBuilder.aWidget().id("widget2").designerVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)this.widgetRepository.get("widget1")).thenReturn((Object)widget1);
        Mockito.when((Object)this.widgetRepository.get("widget2")).thenReturn((Object)widget2);
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget1)).thenReturn((Object)new MigrationResult((Object)widget1Migrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS, "widget1"))));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget2)).thenReturn((Object)new MigrationResult((Object)widget2Migrated, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS, "widget2"))));
        HashSet<String> h = new HashSet<String>(Arrays.asList("widget1", "widget1"));
        Mockito.when((Object)this.widgetRepository.getByIds(h)).thenReturn(Arrays.asList(widget1, widget2));
        Page page = PageBuilder.aPage().with(ComponentBuilder.aComponent("widget1"), ComponentBuilder.aComponent("widget2")).build();
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(h);
        this.widgetService.migrateAllCustomWidgetUsedInPreviewable((Previewable)page);
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget1);
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget2);
    }

    @Test
    public void should_not_update_and_save_widget_if_migration_finish_on_error() {
        Widget widget = WidgetBuilder.aWidget().id("widget").modelVersion("1.0").build();
        Widget widgetMigrated = WidgetBuilder.aWidget().id("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion(CURRENT_MODEL_VERSION).build();
        MigrationResult mr = new MigrationResult((Object)widget, Arrays.asList(new MigrationStepReport(MigrationStatus.ERROR)));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        Mockito.when((Object)this.widgetRepository.get("widget")).thenReturn((Object)widget);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)widgetMigrated);
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_to_migrate() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("widget").designerVersion("1.10.0").build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("widget"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Arrays.asList(widget));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        MigrationStatusReport status = this.widgetService.getMigrationStatusOfCustomWidgetUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(true, true), (Object)status.toString());
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_not_compatible() throws Exception {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Widget widget1 = WidgetBuilder.aWidget().id("widget1").designerVersion("1.10.0").build();
        Widget widget2 = WidgetBuilder.aWidget().id("widget2").modelVersion("2.1").isCompatible(false).isMigration(false).build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("widget1", "widget2"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Arrays.asList(widget1, widget2));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        MigrationStatusReport status = this.widgetService.getMigrationStatusOfCustomWidgetUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(false, false), (Object)status.toString());
    }

    @Test
    public void should_get_correct_migration_status_when_dependency_is_not_to_migrate() throws Exception {
        Widget widget = WidgetBuilder.aWidget().id("widget").designerVersion(CURRENT_MODEL_VERSION).isCompatible(true).isMigration(false).build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("widget"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Arrays.asList(widget));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        MigrationStatusReport status = this.widgetService.getMigrationStatusOfCustomWidgetUsed((Previewable)page);
        Assert.assertEquals((Object)this.getMigrationStatusReport(true, false), (Object)status.toString());
    }

    private String getMigrationStatusReport(boolean compatible, boolean migration) {
        return new MigrationStatusReport(compatible, migration).toString();
    }
}

