/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.io.IOException;
import java.util.HashSet;
import javax.validation.ConstraintViolation;
import org.bonitasoft.web.designer.controller.FakeResource;
import org.bonitasoft.web.designer.controller.FakeService;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.repository.exception.ConstraintValidationException;
import org.bonitasoft.web.designer.repository.exception.InUseException;
import org.bonitasoft.web.designer.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceControllerAdviceTest {
    private MockMvc mockMvc;
    @Mock
    protected FakeService fakeService;
    @InjectMocks
    private FakeResource fakeResource;

    @Before
    public void setUp() {
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.fakeResource).build();
    }

    @Test
    public void should_respond_forbidden_with_json_error() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new NotAllowedException("you are not allowed to do that")).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isForbidden()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"NotAllowedException\",\"message\":\"you are not allowed to do that\"}"));
    }

    @Test
    public void should_respond_notfound_with_json_error() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new NotFoundException("not found")).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isNotFound()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"NotFoundException\",\"message\":\"not found\"}"));
    }

    @Test
    public void should_respond_server_error_with_json_error_on_IOException() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new IOException("Can't read file")).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"IOException\",\"message\":\"Can't read file\"}"));
    }

    @Test
    public void should_respond_internal_error_with_json_error() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new RepositoryException("something went bad on server side", (Throwable)new Exception())).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"RepositoryException\",\"message\":\"something went bad on server side\"}"));
    }

    @Test
    public void should_respond_bad_request_with_json_error() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new IllegalArgumentException("something went bad on server side")).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"IllegalArgumentException\",\"message\":\"something went bad on server side\"}"));
    }

    @Test
    public void should_respond_bad_request_when_handling_ConstraintValidationException() throws Exception {
        HashSet<ConstraintViolation<Object>> set = new HashSet<ConstraintViolation<Object>>();
        set.add(this.aConstraintViolation("here goes bad"));
        ((FakeService)Mockito.doThrow((Throwable)new ConstraintValidationException(set)).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"ConstraintValidationException\",\"message\":\"here goes bad\"}"));
    }

    private ConstraintViolation<Object> aConstraintViolation(String message) {
        ConstraintViolation violation = (ConstraintViolation)Mockito.mock(ConstraintViolation.class);
        Mockito.when((Object)violation.getMessage()).thenReturn((Object)message);
        return violation;
    }

    @Test
    public void should_respond_conflict_with_json_error() throws Exception {
        ((FakeService)Mockito.doThrow((Throwable)new InUseException("conflict")).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isConflict()).andExpect(MockMvcResultMatchers.content().string("{\"type\":\"InUseException\",\"message\":\"conflict\"}"));
    }

    @Test
    public void should_respond_accepted_with_json_error_on_ImportException() throws Exception {
        ImportException exception = new ImportException(ImportException.Type.CANNOT_OPEN_ZIP, "an error occurs");
        ((FakeService)Mockito.doThrow((Throwable)exception).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.content().json("{\"type\":\"CANNOT_OPEN_ZIP\",\"message\":\"an error occurs\"}"));
    }

    @Test
    public void should_respond_accepted_with_json_error_containing_additionnal_infos_on_ImportExceptio() throws Exception {
        ImportException exception = new ImportException(ImportException.Type.CANNOT_OPEN_ZIP, "an error occurs");
        exception.addInfo("additionnalInfo", (Object)"here is something");
        ((FakeService)Mockito.doThrow((Throwable)exception).when((Object)this.fakeService)).doSomething();
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/fake/resource", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().contentType("application/json;charset=UTF-8")).andExpect(MockMvcResultMatchers.status().isAccepted()).andExpect(MockMvcResultMatchers.content().json("{\"type\":\"CANNOT_OPEN_ZIP\",\"message\":\"an error occurs\",\"infos\":{\"additionnalInfo\":\"here is something\"}}"));
    }
}

