/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.nio.file.Path;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.bonitasoft.web.designer.controller.export.steps.AssetExportStep;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.AssetRepository;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssetExportStepTest {
    @Mock
    private AssetRepository<Page> pageAssetRepository;
    @Mock
    private Zipper zipper;
    @Mock
    private Path assetPath;
    @InjectMocks
    private AssetExportStep assetExportStep;

    @Test
    public void should_call_zipper_when_page_has_no_asset() throws Exception {
        this.assetExportStep.execute(this.zipper, PageBuilder.aPage().build());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.zipper});
    }

    @Test
    public void should_export_asset_when_page_has_asset() throws Exception {
        Mockito.when((Object)this.pageAssetRepository.findAssetPath("pageId", "myfile.css", AssetType.CSS)).thenReturn((Object)this.assetPath);
        Page page = PageBuilder.aPage().withId("pageId").withAsset(AssetBuilder.anAsset().withName("myfile.css").withType(AssetType.CSS)).build();
        this.assetExportStep.execute(this.zipper, page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addDirectoryToZip(this.assetPath, Zipper.ALL_DIRECTORIES, Zipper.ALL_FILES, "resources/assets/css/myfile.css");
    }

    @Test
    public void should_not_export_external_assets() throws Exception {
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withName("http://external.asset").withExternal(true)).build();
        this.assetExportStep.execute(this.zipper, page);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.zipper});
    }
}

