/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.OutputStream;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.controller.export.Zipper;
import org.bonitasoft.web.designer.controller.export.steps.FragmentPropertiesExportStep;
import org.bonitasoft.web.designer.controller.export.steps.FragmentsExportStep;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.utils.rule.TemporaryFragmentRepository;
import org.bonitasoft.web.designer.visitor.FragmentIdVisitor;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentsExportStepTest {
    private WorkspacePathResolver pathResolver = (WorkspacePathResolver)Mockito.mock(WorkspacePathResolver.class);
    @Rule
    public TemporaryFragmentRepository repository = new TemporaryFragmentRepository(this.pathResolver);
    private FragmentsExportStep step;
    @Mock
    private FragmentPropertiesExportStep fragmentPropertiesExportStep;
    @Mock
    private Zipper zipper;

    @Before
    public void beforeEach() {
        this.step = new FragmentsExportStep(new FragmentIdVisitor(this.repository.toRepository()), this.pathResolver, this.fragmentPropertiesExportStep);
        this.zipper = (Zipper)Mockito.spy((Object)new Zipper((OutputStream)Mockito.mock(OutputStream.class)));
    }

    @Test
    public void should_add_fragments_to_zip() throws Exception {
        Page page = PageBuilder.aPage().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment")).build();
        this.repository.addFragment(FragmentBuilder.aFragment().id("fragment"));
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(this.repository.resolveFragmentJson("fragment"), "resources/fragments/fragment/fragment.json");
    }

    public void should_not_add_fragment_metadata_to_zip() throws Exception {
        Page page = PageBuilder.aPage().with(FragmentElementBuilder.aFragmentElement().withFragmentId("fragment")).build();
        this.repository.addFragment(FragmentBuilder.aFragment().id("fragment"));
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper, (VerificationMode)Mockito.never())).addToZip(this.repository.resolveFragmentMetadata("fragment"), "resources/fragments/fragment/fragment.metadata.json");
    }
}

