/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.generator.mapping.ContractInputDataHandler;
import org.bonitasoft.web.designer.generator.mapping.ContractInputToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.generator.parametrizedWidget.ButtonAction;
import org.bonitasoft.web.designer.generator.widgets.PbInput;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.contract.BusinessDataReference;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.DataReference;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Test;

public class ContractInputToWidgetMapperTest {
    JacksonObjectMapper objectMapper = new DesignerConfig().objectMapperWrapper();

    @Test
    public void should_string_contract_input_create_an_input_widget_id() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = (Component)contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aStringContractInput((String)"firstName"), Collections.emptyList());
        Assertions.assertThat((String)element.getId()).isEqualTo((Object)"pbInput");
    }

    @Test
    public void should_read_only_string_contract_input_create_an_text_widget_id() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = (Component)contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aReadOnlyStringContractInput((String)"firstName"), Collections.emptyList());
        Assertions.assertThat((String)element.getId()).isEqualTo((Object)"pbText");
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("allowHtml")).getValue()).isEqualTo((Object)true);
    }

    @Test
    public void should_map_simple_numeric_input_to_an_input_widget_id() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = (Component)contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aLongContractInput((String)"updateTime"), Collections.emptyList());
        Assertions.assertThat((String)element.getId()).isEqualTo((Object)"pbInput");
    }

    @Test
    public void should_map_input_name_to_a_widget_display_label() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Element element = contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aStringContractInput((String)"aComplicatedCamelCaseInputName"), Collections.emptyList());
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("label")).getValue()).isEqualTo((Object)"A Complicated Camel Case Input Name");
    }

    @Test
    public void should_map_a_numeric_contract_input_to_an_input_with_number_type() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Element element = contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aLongContractInput((String)"timestamp"), Collections.emptyList());
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("type")).getValue()).isEqualTo((Object)"number");
    }

    @Test
    public void should_map_a_non_numeric_contract_input_to_an_input_with_text_type() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Element element = contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aStringContractInput((String)"name"), Collections.emptyList());
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("type")).getValue()).isEqualTo((Object)"text");
    }

    @Test
    public void should_keep_default_placeholder_input_when_contract_input_have_description() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        LeafContractInput contractInput = ContractInputBuilder.aStringContractInput((String)"name");
        contractInput.setDescription("name of the user");
        Element element = contractInputToWidgetMapper.toElement((ContractInput)contractInput, Collections.emptyList());
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("placeholder")).getValue()).isEqualTo((Object)new PbInput().getPlaceholder());
    }

    @Test
    public void should_submit_button_have_contract_action() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = contractInputToWidgetMapper.createSubmitButton(ButtonAction.SUBMIT_TASK);
        Assertions.assertThat((Object)((PropertyValue)element.getPropertyValues().get("action")).getValue()).isEqualTo((Object)"Submit task");
    }

    @Test
    public void should_submit_button_send_sentData_variable() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = contractInputToWidgetMapper.createSubmitButton(ButtonAction.SUBMIT_TASK);
        PropertyValue PropertyValue2 = (PropertyValue)element.getPropertyValues().get("dataToSend");
        Assertions.assertThat((String)PropertyValue2.getType()).isEqualTo((Object)"expression");
        Assertions.assertThat((Object)PropertyValue2.getValue()).isEqualTo((Object)"formOutput");
    }

    @Test
    public void submit_button_should_redirect_to_bonita_on_success() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Component element = contractInputToWidgetMapper.createSubmitButton(ButtonAction.SUBMIT_TASK);
        PropertyValue PropertyValue2 = (PropertyValue)element.getPropertyValues().get("targetUrlOnSuccess");
        Assertions.assertThat((String)PropertyValue2.getType()).isEqualTo((Object)"interpolation");
        Assertions.assertThat((Object)PropertyValue2.getValue()).isEqualTo((Object)"/bonita");
    }

    @Test
    public void should_string_contract_input_has_value_configured_on_sentData() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Element element = contractInputToWidgetMapper.toElement((ContractInput)ContractInputBuilder.aStringContractInput((String)"firstName"), Collections.emptyList());
        PropertyValue valueParameter = (PropertyValue)element.getPropertyValues().get("value");
        Assertions.assertThat((String)valueParameter.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)valueParameter.getValue()).isEqualTo((Object)"formInput.firstName");
    }

    @Test
    public void should_configure_value_property_of_container_with_$item_when_generating_a_multiple_string_in_a_multiple_node_contract_input() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        ContractInput contractInput = ContractInputBuilder.aContractInput((String)"names").mulitple().withType(String.class.getName()).build();
        ContractInputBuilder.aNodeContractInput((String)"employee").mulitple().withInput(new ContractInput[]{contractInput}).build();
        Element container = contractInputToWidgetMapper.toElement(contractInput, new ArrayList());
        Assertions.assertThat((Object)container).isInstanceOf(Container.class);
        PropertyValue repeatedCollectionPropetyValue = (PropertyValue)container.getPropertyValues().get("repeatedCollection");
        Assertions.assertThat((String)repeatedCollectionPropetyValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollectionPropetyValue.getValue()).isEqualTo((Object)"$item.names");
    }

    @Test
    public void should_configure_value_property_of_container_with_sentData_when_generating_a_multiple_node_input() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        Container container = contractInputToWidgetMapper.toContainer((NodeContractInput)ContractInputBuilder.aNodeContractInput((String)"employee").mulitple().build(), new ArrayList());
        PropertyValue repeatedCollectionPropetyValue = (PropertyValue)container.getPropertyValues().get("repeatedCollection");
        Assertions.assertThat((String)repeatedCollectionPropetyValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollectionPropetyValue.getValue()).isEqualTo((Object)"formInput.employee");
    }

    @Test
    public void should_configure_collection_property_of_add_button_with_iterator_if_in_a_repeated_container() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        ContractInput skills = ContractInputBuilder.aNodeContractInput((String)"skills").withDataReference(new BusinessDataReference("skills", "org.test.Skill", BusinessDataReference.RelationType.COMPOSITION, BusinessDataReference.LoadingType.EAGER)).mulitple().build();
        ContractInputBuilder.aNodeContractInput((String)"employee").mulitple().withInput(new ContractInput[]{skills});
        Component button = contractInputToWidgetMapper.createAddButton(skills);
        PropertyValue labelValue = (PropertyValue)button.getPropertyValues().get("label");
        Assertions.assertThat((Object)labelValue.getValue()).isEqualTo((Object)"<span class=\"glyphicon glyphicon-plus\"></span> Add Skill");
        PropertyValue repeatedCollectionPropetyValue = (PropertyValue)button.getPropertyValues().get("collectionToModify");
        Assertions.assertThat((String)repeatedCollectionPropetyValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollectionPropetyValue.getValue()).isEqualTo((Object)"$item.skills");
    }

    @Test
    public void should_configure_collection_property_of_remove_button_with_iterator_if_in_a_repeated_container() throws Exception {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        ContractInput skills = ContractInputBuilder.aNodeContractInput((String)"skills").mulitple().build();
        ContractInputBuilder.aNodeContractInput((String)"employee").mulitple().withInput(new ContractInput[]{skills});
        Component button = contractInputToWidgetMapper.createRemoveButton();
        PropertyValue repeatedCollectionPropetyValue = (PropertyValue)button.getPropertyValues().get("collectionToModify");
        Assertions.assertThat((String)repeatedCollectionPropetyValue.getType()).isEqualTo((Object)"variable");
        Assertions.assertThat((Object)repeatedCollectionPropetyValue.getValue()).isEqualTo((Object)"$collection");
    }

    @Test
    public void should_create_single_document_to_edit() {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        LeafContractInput fileContractInput = ContractInputBuilder.aFileContractInput((String)"aDocument.txt");
        ContractInputDataHandler dataHandler = new ContractInputDataHandler((ContractInput)fileContractInput);
        Assertions.assertThat((boolean)dataHandler.isDocumentEdition()).isFalse();
        fileContractInput.setDataReference(new DataReference("myDoc", File.class.getName()));
        fileContractInput.setMode(EditMode.EDIT);
        Assertions.assertThat((boolean)dataHandler.isDocumentEdition()).isTrue();
        Container container = (Container)contractInputToWidgetMapper.toDocument(fileContractInput);
        Component titleComponent = (Component)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)titleComponent.getId()).isEqualTo((Object)"pbTitle");
        PropertyValue textProperty = (PropertyValue)titleComponent.getPropertyValues().get("text");
        Assertions.assertThat((Object)textProperty.getValue()).isEqualTo((Object)"My Doc");
        Component fileViewerComponent = (Component)((List)container.getRows().get(1)).get(0);
        Assertions.assertThat((String)fileViewerComponent.getId()).isEqualTo((Object)"pbFileViewer");
        PropertyValue documentProperty = (PropertyValue)fileViewerComponent.getPropertyValues().get("document");
        Assertions.assertThat((Object)documentProperty.getValue()).isEqualTo((Object)"context.myDoc_ref");
        Component fileUploadComponent = (Component)((List)container.getRows().get(2)).get(0);
        Assertions.assertThat((String)fileUploadComponent.getId()).isEqualTo((Object)"pbUpload");
        PropertyValue labelHiddenProperty = (PropertyValue)fileUploadComponent.getPropertyValues().get("labelHidden");
        Assertions.assertThat((Object)labelHiddenProperty.getValue()).isEqualTo((Object)Boolean.TRUE);
        PropertyValue valueProperty = (PropertyValue)fileUploadComponent.getPropertyValues().get("value");
        Assertions.assertThat((Object)valueProperty.getValue()).isEqualTo((Object)"context.myDoc_ref.newValue");
    }

    @Test
    public void should_create_multiple_document_to_edit_container() {
        ContractInputToWidgetMapper contractInputToWidgetMapper = this.makeContractInputToWidgetMapper();
        LeafContractInput fileContractInput = ContractInputBuilder.aFileContractInput((String)"aDocument.txt");
        fileContractInput.setMultiple(true);
        fileContractInput.setMode(EditMode.EDIT);
        ContractInputDataHandler dataHandler = new ContractInputDataHandler((ContractInput)fileContractInput);
        fileContractInput.setDataReference(new DataReference("myDoc", File.class.getName()));
        Assertions.assertThat((boolean)dataHandler.isDocumentEdition()).isTrue();
        Element element = contractInputToWidgetMapper.toDocument(fileContractInput);
        Assertions.assertThat((Object)element).isInstanceOf(Container.class);
        Container container = (Container)element;
        Assertions.assertThat((List)container.getRows()).hasSize(2);
        Assertions.assertThat((boolean)container.isRepeated()).isFalse();
        Component title = (Component)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)title.getId()).isEqualTo((Object)"pbTitle");
        Container multipleContainer = (Container)((List)container.getRows().get(1)).get(0);
        Map propertyValues = multipleContainer.getPropertyValues();
        PropertyValue repeatedCollectionProperty = (PropertyValue)propertyValues.get("repeatedCollection");
        Assertions.assertThat((Object)repeatedCollectionProperty.getValue()).isEqualTo((Object)"context.myDoc_ref");
        Component fileViewerComponent = (Component)((List)multipleContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)fileViewerComponent.getId()).isEqualTo((Object)"pbFileViewer");
        PropertyValue documentProperty = (PropertyValue)fileViewerComponent.getPropertyValues().get("document");
        Assertions.assertThat((Object)documentProperty.getValue()).isEqualTo((Object)"$item");
        Component fileUploadComponent = (Component)((List)multipleContainer.getRows().get(1)).get(0);
        Assertions.assertThat((String)fileUploadComponent.getId()).isEqualTo((Object)"pbUpload");
        PropertyValue labelHiddenProperty = (PropertyValue)fileUploadComponent.getPropertyValues().get("labelHidden");
        Assertions.assertThat((Object)labelHiddenProperty.getValue()).isEqualTo((Object)Boolean.TRUE);
        PropertyValue valueProperty = (PropertyValue)fileUploadComponent.getPropertyValues().get("value");
        Assertions.assertThat((Object)valueProperty.getValue()).isEqualTo((Object)"$item.newValue");
    }

    private ContractInputToWidgetMapper makeContractInputToWidgetMapper() {
        return new ContractInputToWidgetMapper(new DimensionFactory(), this.objectMapper);
    }
}

