/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.generator.mapping;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PropertyValueBuilder;
import org.bonitasoft.web.designer.generator.mapping.ContractInputToWidgetMapper;
import org.bonitasoft.web.designer.generator.mapping.ContractInputVisitorImpl;
import org.bonitasoft.web.designer.generator.mapping.DimensionFactory;
import org.bonitasoft.web.designer.model.ElementContainer;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.contract.ContractInput;
import org.bonitasoft.web.designer.model.contract.EditMode;
import org.bonitasoft.web.designer.model.contract.LeafContractInput;
import org.bonitasoft.web.designer.model.contract.NodeContractInput;
import org.bonitasoft.web.designer.model.contract.builders.ContractBuilder;
import org.bonitasoft.web.designer.model.contract.builders.ContractInputBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.junit.Before;
import org.junit.Test;

public class ContractInputVisitorImplTest {
    private JacksonObjectMapper objectMapper = new JacksonObjectMapper(new ObjectMapper());
    private ContractInputToWidgetMapper contractInputToWidgetMapper;

    @Before
    public void setUp() throws Exception {
        this.contractInputToWidgetMapper = new ContractInputToWidgetMapper(new DimensionFactory(), this.objectMapper);
    }

    @Test
    public void add_a_one_row_component_when_visiting_a_leaf_contract_input() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit(ContractInputBuilder.aStringContractInput((String)"name"));
        Assertions.assertThat((List)page.getRows()).hasSize(1);
        Assertions.assertThat((List)((List)page.getRows().get(0))).hasSize(1);
        Assertions.assertThat(((List)page.getRows().get(0)).get(0)).isInstanceOf(Component.class);
    }

    @Test
    public void do_nothing_when_visiting_a_leaf_contract_input_with_unsupported_type() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit(new LeafContractInput("unsupported", IllegalArgumentException.class));
        Assertions.assertThat((List)page.getRows()).hasSize(0);
    }

    @Test
    public void add_a_component_embedded_in_a_container_with_buttons_when_visiting_a_multiple_leaf_contract_input() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit((LeafContractInput)ContractInputBuilder.aContractInput((String)"names").mulitple().build());
        Assertions.assertThat((List)page.getRows()).hasSize(3);
        List firstRow = (List)page.getRows().get(0);
        Assertions.assertThat((List)firstRow).hasSize(1);
        Assertions.assertThat(firstRow.get(0)).isInstanceOf(Component.class);
        Assertions.assertThat((String)((Component)firstRow.get(0)).getId()).isEqualTo((Object)"pbTitle");
        Assertions.assertThat((Map)((Element)firstRow.get(0)).getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"text", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Names"))});
        List secondRow = (List)page.getRows().get(1);
        Assertions.assertThat((List)secondRow).hasSize(1);
        Assertions.assertThat(secondRow.get(0)).isInstanceOf(Container.class);
        Container container = (Container)secondRow.get(0);
        Assertions.assertThat((List)container.getRows()).hasSize(1);
        List secondRowInner = (List)container.getRows().get(0);
        Assertions.assertThat((List)secondRowInner).hasSize(2);
        Component component = (Component)secondRowInner.get(0);
        Assertions.assertThat((String)component.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)component.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue(""))});
        Component removeButton = (Component)secondRowInner.get(1);
        Assertions.assertThat((String)removeButton.getId()).isEqualTo((Object)"pbButton");
        List thirdRow = (List)page.getRows().get(2);
        Assertions.assertThat((List)thirdRow).hasSize(1);
        Component addButton = (Component)thirdRow.get(0);
        Assertions.assertThat((String)addButton.getId()).isEqualTo((Object)"pbButton");
        Assertions.assertThat((Object)((PropertyValue)addButton.getPropertyValues().get("valueToAdd")).getValue()).isNull();
    }

    @Test
    public void add_a_children_components_embedded_in_a_container_when_visiting_a_node_contract_input() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit((NodeContractInput)ContractInputBuilder.aNodeContractInput((String)"employee").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"firstName"), ContractInputBuilder.aStringContractInput((String)"lastName")}).build());
        Assertions.assertThat((List)page.getRows()).hasSize(2);
        List firstRow = (List)page.getRows().get(0);
        Assertions.assertThat((List)firstRow).hasSize(1);
        Assertions.assertThat(firstRow.get(0)).isInstanceOf(Component.class);
        Assertions.assertThat((String)((Component)firstRow.get(0)).getId()).isEqualTo((Object)"pbTitle");
        Assertions.assertThat((Map)((Element)firstRow.get(0)).getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"text", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Employee"))});
        List secondRow = (List)page.getRows().get(1);
        Assertions.assertThat((List)secondRow).hasSize(1);
        Assertions.assertThat(secondRow.get(0)).isInstanceOf(Container.class);
        Container container = (Container)secondRow.get(0);
        Assertions.assertThat((List)container.getRows()).hasSize(2);
        Assertions.assertThat((List)((List)container.getRows().get(0))).hasSize(1);
        Component firstNameComponent = (Component)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)firstNameComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)firstNameComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("First Name"))});
        Component lastNameComponent = (Component)((List)container.getRows().get(1)).get(0);
        Assertions.assertThat((String)lastNameComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)lastNameComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Last Name"))});
    }

    @Test
    public void add_a_children_components_embedded_in_a_container_with_buttons_when_visiting_a_multiple_node_contract_input() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit((NodeContractInput)ContractInputBuilder.aNodeContractInput((String)"employee").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"firstName"), ContractInputBuilder.aStringContractInput((String)"lastName")}).mulitple().build());
        Assertions.assertThat((List)page.getRows()).hasSize(3);
        List firstRow = (List)page.getRows().get(0);
        Assertions.assertThat((List)firstRow).hasSize(1);
        Assertions.assertThat(firstRow.get(0)).isInstanceOf(Component.class);
        Assertions.assertThat((String)((Component)firstRow.get(0)).getId()).isEqualTo((Object)"pbTitle");
        Assertions.assertThat((Map)((Element)firstRow.get(0)).getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"text", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Employee"))});
        List secondRow = (List)page.getRows().get(1);
        Assertions.assertThat((List)secondRow).hasSize(1);
        Assertions.assertThat(secondRow.get(0)).isInstanceOf(Container.class);
        Container container = (Container)secondRow.get(0);
        Assertions.assertThat((List)container.getRows()).hasSize(3);
        Assertions.assertThat((List)((List)container.getRows().get(0))).hasSize(1);
        Component firstNameComponent = (Component)((List)container.getRows().get(0)).get(0);
        Assertions.assertThat((String)firstNameComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)firstNameComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("First Name"))});
        Assertions.assertThat((List)((List)container.getRows().get(1))).hasSize(1);
        Component lastNameComponent = (Component)((List)container.getRows().get(1)).get(0);
        Assertions.assertThat((String)lastNameComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)lastNameComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Last Name"))});
        Assertions.assertThat((List)((List)container.getRows().get(2))).hasSize(1);
        Component removeButton = (Component)((List)container.getRows().get(2)).get(0);
        Assertions.assertThat((String)removeButton.getId()).isEqualTo((Object)"pbButton");
        List thirdRow = (List)page.getRows().get(2);
        Assertions.assertThat((List)thirdRow).hasSize(1);
        Component addButton = (Component)thirdRow.get(0);
        Assertions.assertThat((String)addButton.getId()).isEqualTo((Object)"pbButton");
        Assertions.assertThat((Object)((PropertyValue)addButton.getPropertyValues().get("valueToAdd")).getValue()).isEqualTo((Object)("{" + System.lineSeparator() + "  \"firstName\" : \"\"," + System.lineSeparator() + "  \"lastName\" : \"\"" + System.lineSeparator() + "}"));
    }

    @Test
    public void add_a_complex_children_components_embedded_in_a_container_when_visiting_a_multiple_complex_node_contract_input() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit((NodeContractInput)ContractInputBuilder.aNodeContractInput((String)"complex").mulitple().withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"subcomplex").withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"lastName")}).build()}).withInput(new ContractInput[]{ContractInputBuilder.aNodeContractInput((String)"subcomplexMultiple").mulitple().withInput(new ContractInput[]{ContractInputBuilder.aStringContractInput((String)"friend")}).build()}).build());
        Assertions.assertThat((List)page.getRows()).hasSize(3);
        this.checkSubcomplexTitle((List)page.getRows().get(0), "Complex");
        List complexSecondRow = (List)page.getRows().get(1);
        Assertions.assertThat((List)complexSecondRow).hasSize(1);
        Assertions.assertThat(complexSecondRow.get(0)).isInstanceOf(Container.class);
        Container complexContainer = (Container)complexSecondRow.get(0);
        Assertions.assertThat((Map)complexContainer.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"repeatedCollection", (Object)PropertyValueBuilder.aDataPropertyValue("formInput.complex"))});
        Assertions.assertThat((List)complexContainer.getRows()).hasSize(6);
        Assertions.assertThat((List)((List)complexContainer.getRows().get(0))).hasSize(1);
        this.checkSubcomplex(complexContainer);
        this.checkComplexRemoveButton(complexContainer, 5);
        List thirdRow = (List)page.getRows().get(2);
        Assertions.assertThat((List)thirdRow).hasSize(1);
        Component addButton = (Component)thirdRow.get(0);
        Assertions.assertThat((String)addButton.getId()).isEqualTo((Object)"pbButton");
        Assertions.assertThat((Object)((PropertyValue)addButton.getPropertyValues().get("valueToAdd")).getValue()).isEqualTo((Object)("{" + System.lineSeparator() + "  \"subcomplex\" : {" + System.lineSeparator() + "    \"lastName\" : \"\"" + System.lineSeparator() + "  }," + System.lineSeparator() + "  \"subcomplexMultiple\" : [ ]" + System.lineSeparator() + "}"));
    }

    @Test
    public void should_not_add_simple_aggregated_relation_in_a_container() throws Exception {
        Page page = new Page();
        new ContractInputVisitorImpl((ElementContainer)page, this.contractInputToWidgetMapper).visit((NodeContractInput)ContractBuilder.aContractWithDataRefAndAggregation((EditMode)EditMode.CREATE).getInput().get(0));
        Container formContainer = (Container)((List)page.getRows().get(1)).get(0);
        Component select = (Component)((List)formContainer.getRows().get(3)).get(0);
        Assertions.assertThat((String)select.getId()).isEqualTo((Object)"pbSelect");
    }

    private void checkComplexRemoveButton(Container complexContainer, int index) {
        Assertions.assertThat((List)((List)complexContainer.getRows().get(index))).hasSize(1);
        Component removeButton = (Component)((List)complexContainer.getRows().get(index)).get(0);
        Assertions.assertThat((Object)((PropertyValue)removeButton.getPropertyValues().get("collectionToModify")).getValue()).isEqualTo((Object)"$collection");
        Assertions.assertThat((String)removeButton.getId()).isEqualTo((Object)"pbButton");
    }

    private void checkSubcomplexTitle(List<Element> complexFirstRow, String title) {
        Assertions.assertThat(complexFirstRow).hasSize(1);
        Assertions.assertThat((String)((Component)complexFirstRow.get(0)).getId()).isEqualTo((Object)"pbTitle");
        Assertions.assertThat((Map)complexFirstRow.get(0).getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"text", (Object)PropertyValueBuilder.aInterpolationPropertyValue(title))});
    }

    private void checkSubcomplex(Container complexContainer) {
        Component subcomplexComponent = (Component)((List)complexContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)subcomplexComponent.getId()).isEqualTo((Object)"pbTitle");
        Assertions.assertThat((Map)subcomplexComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"text", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Subcomplex"))});
        List subcomplexSecondRow = (List)complexContainer.getRows().get(1);
        Assertions.assertThat((List)subcomplexSecondRow).hasSize(1);
        Assertions.assertThat(subcomplexSecondRow.get(0)).isInstanceOf(Container.class);
        Container subComplexContainer = (Container)subcomplexSecondRow.get(0);
        Assertions.assertThat((Map)subComplexContainer.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"repeatedCollection", (Object)PropertyValueBuilder.aDataPropertyValue(null))});
        Assertions.assertThat((List)subComplexContainer.getRows()).hasSize(1);
        Assertions.assertThat((List)((List)subComplexContainer.getRows().get(0))).hasSize(1);
        Component lastnameInputComponent = (Component)((List)subComplexContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)lastnameInputComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)lastnameInputComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Last Name")), Assertions.entry((Object)"value", (Object)PropertyValueBuilder.aDataPropertyValue("$item.subcomplex.lastName"))});
        this.checkSubcomplexTitle((List)complexContainer.getRows().get(2), "Subcomplex Multiple");
        List complexFourthRow = (List)complexContainer.getRows().get(3);
        Assertions.assertThat((List)complexFourthRow).hasSize(1);
        Assertions.assertThat(complexFourthRow.get(0)).isInstanceOf(Container.class);
        Container complexSecondContainer = (Container)complexFourthRow.get(0);
        Assertions.assertThat((Map)complexSecondContainer.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"repeatedCollection", (Object)PropertyValueBuilder.aDataPropertyValue("$item.subcomplexMultiple"))});
        Assertions.assertThat((List)complexSecondContainer.getRows()).hasSize(2);
        Assertions.assertThat((List)((List)complexSecondContainer.getRows().get(0))).hasSize(1);
        Component friendsInputComponent = (Component)((List)complexSecondContainer.getRows().get(0)).get(0);
        Assertions.assertThat((String)friendsInputComponent.getId()).isEqualTo((Object)"pbInput");
        Assertions.assertThat((Map)friendsInputComponent.getPropertyValues()).contains(new Map.Entry[]{Assertions.entry((Object)"label", (Object)PropertyValueBuilder.aInterpolationPropertyValue("Friend")), Assertions.entry((Object)"value", (Object)PropertyValueBuilder.aDataPropertyValue("$item.friend"))});
        this.checkComplexRemoveButton(complexSecondContainer, 1);
        List addButtonRow = (List)complexContainer.getRows().get(4);
        Assertions.assertThat((List)addButtonRow).hasSize(1);
        Component addButton = (Component)addButtonRow.get(0);
        Assertions.assertThat((String)addButton.getId()).isEqualTo((Object)"pbButton");
        Assertions.assertThat((Object)((PropertyValue)addButton.getPropertyValues().get("valueToAdd")).getValue()).isEqualTo((Object)("{" + System.lineSeparator() + "  \"friend\" : \"\"" + System.lineSeparator() + "}"));
    }
}

