/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bonitasoft.web.designer.i18n.I18nInitializer;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=MockitoJUnitRunner.class)
@WebAppConfiguration(value="file:target/test-classes")
public class I18nInitializerTest {
    @Mock
    LanguagePackBuilder languagePackBuilder;
    @InjectMocks
    I18nInitializer i18nInitializer;

    @Test
    public void should_start_live_build_on_po_directory() throws Exception {
        this.i18nInitializer.contextInitialized();
        ((LanguagePackBuilder)Mockito.verify((Object)this.languagePackBuilder)).start((Path)Matchers.eq((Object)Paths.get("target/test-classes/i18n", new String[0]).toAbsolutePath()));
    }

    @Test(expected=RuntimeException.class)
    public void should_throw_a_runtime_exception_on_io_error() throws Exception {
        ((LanguagePackBuilder)Mockito.doThrow((Throwable)new IOException()).when((Object)this.languagePackBuilder)).start((Path)Matchers.any(Path.class));
        this.i18nInitializer.contextInitialized();
    }
}

