/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.AssetExternalMigrationStep;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.Test;

public class AssetExternalMigrationStepTest {
    @Test
    public void should_migrate_artifact_assets() throws Exception {
        AssetExternalMigrationStep migrationStep = new AssetExternalMigrationStep();
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withName("bonita.jpg")).withAsset(AssetBuilder.anAsset().withName("http://www.bonitasoft.com")).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((Iterable)page.getAssets()).extracting(new String[]{"name", "external"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"bonita.jpg", false}), Assertions.tuple((Object[])new Object[]{"http://www.bonitasoft.com", true})});
    }

    @Test
    public void should_not_change_an_asset_external_property() throws Exception {
        AssetExternalMigrationStep migrationStep = new AssetExternalMigrationStep();
        Page page = PageBuilder.aPage().withAsset(AssetBuilder.anAsset().withExternal(false).withName("bonita.jpg")).withAsset(AssetBuilder.anAsset().withExternal(true).withName("https://www.bonitasoft.com")).build();
        migrationStep.migrate((Identifiable)page);
        Assertions.assertThat((Iterable)page.getAssets()).extracting(new String[]{"name", "external"}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"bonita.jpg", false}), Assertions.tuple((Object[])new Object[]{"https://www.bonitasoft.com", true})});
    }
}

