/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.model.asset;

import com.fasterxml.jackson.databind.ObjectMapper;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetScope;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.exception.ConstraintValidationException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class AssetTest {
    private BeanValidator beanValidator = new DesignerConfig().beanValidator();
    private Asset asset;
    private ObjectMapper objectMapper;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void init() {
        this.objectMapper = new DesignerConfig().objectMapper();
        this.asset = AssetBuilder.anAsset().withScope(AssetScope.PAGE).build();
    }

    protected Object[] validNames() {
        return JUnitParamsRunner.$((Object[])new Object[]{JUnitParamsRunner.$((Object[])new Object[]{"test.js"}), JUnitParamsRunner.$((Object[])new Object[]{"jquery-1.11.3.min.js"}), JUnitParamsRunner.$((Object[])new Object[]{"jquery-1.11.3.min-SNAPSHOT.js"}), JUnitParamsRunner.$((Object[])new Object[]{"copy jquery.js"}), JUnitParamsRunner.$((Object[])new Object[]{"jquery(1).js"}), JUnitParamsRunner.$((Object[])new Object[]{"myimage_test.jpg"}), JUnitParamsRunner.$((Object[])new Object[]{"myimage_test.PNG"}), JUnitParamsRunner.$((Object[])new Object[]{"https://code.jquery.com/jquery-2.1.4.min.js"}), JUnitParamsRunner.$((Object[])new Object[]{"http://code.jquery.com/jquery-2.1.4.min.js"}), JUnitParamsRunner.$((Object[])new Object[]{"https://code.jquery.com/jquery-2.1.4.min.JS"}), JUnitParamsRunner.$((Object[])new Object[]{"https://code.jquery.com/jquery version 2.1.4.min.js"}), JUnitParamsRunner.$((Object[])new Object[]{"http://code.jquery.com/jquery%20%402.1.4.min.js"}), JUnitParamsRunner.$((Object[])new Object[]{"my\u00e9&name.js.js"}), JUnitParamsRunner.$((Object[])new Object[]{"http_test.js"})});
    }

    protected Object[] invalidNames() {
        String errorMessage = "Asset name should be a filename containing only alphanumeric characters and no space or an external URL";
        return JUnitParamsRunner.$((Object[])JUnitParamsRunner.$((Object[])new Object[]{null, "Asset name should not be blank"}));
    }

    @Test
    @Parameters(method="validNames")
    public void should_be_valid_when_name_is_valid(String name) {
        this.asset.setName(name);
        this.beanValidator.validate((Object)this.asset);
    }

    @Test
    @Parameters(method="invalidNames")
    public void should_be_invalid_when_name_is_invalid(String name, String expectedErrorMessage) {
        this.exception.expect(ConstraintValidationException.class);
        this.exception.expectMessage(expectedErrorMessage);
        this.asset.setName(name);
        this.beanValidator.validate((Object)this.asset);
    }

    @Test
    public void should_be_invalid_when_type_null() {
        this.exception.expect(ConstraintValidationException.class);
        this.exception.expectMessage("Asset type may not be null");
        this.asset.setType(null);
        this.beanValidator.validate((Object)this.asset);
    }

    @Test
    public void json_view_asset_should_persist_all_the_properties() throws Exception {
        String json = this.objectMapper.writerWithView(Asset.JsonViewAsset.class).writeValueAsString((Object)new Asset().setId("UIID").setName("file.js").setType(AssetType.JAVASCRIPT).setComponentId("page-id").setOrder(1).setActive(true).setScope(AssetScope.PAGE));
        Assertions.assertThat((String)json).isEqualTo((Object)"{\"id\":\"UIID\",\"name\":\"file.js\",\"type\":\"js\",\"componentId\":\"page-id\",\"scope\":\"page\",\"order\":1,\"active\":true,\"external\":false}");
    }

    @Test
    public void json_view_persistence_should_persist_a_subset_of_properties() throws Exception {
        String json = this.objectMapper.writerWithView(JsonViewPersistence.class).writeValueAsString((Object)new Asset().setId("UIID").setName("file.js").setType(AssetType.JAVASCRIPT).setComponentId("page-id").setOrder(1).setActive(true).setScope(AssetScope.PAGE));
        Assertions.assertThat((String)json).isEqualTo((Object)"{\"id\":\"UIID\",\"name\":\"file.js\",\"type\":\"js\",\"order\":1,\"external\":false}");
    }
}

