/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetImporter;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.bonitasoft.web.designer.workspace.FragmentDirectiveBuilder;
import org.bonitasoft.web.designer.workspace.WidgetDirectiveBuilder;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.util.ReflectionTestUtils;

public class WorkspaceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Mock
    private Environment env;
    @Mock
    private WorkspacePathResolver pathResolver;
    @Mock
    private WidgetDirectiveBuilder widgetDirectiveBuilder;
    @Mock
    private FragmentDirectiveBuilder fragmentDirectiveBuilder;
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private AssetImporter<Widget> widgetAssetImporter;
    @Mock
    private Resource resource;
    @Mock
    private BeanValidator validator;
    private JsonFileBasedPersister<Widget> widgetPersister = new DesignerConfig().widgetFileBasedPersister();
    private JacksonObjectMapper jacksonObjectMapper = new DesignerConfig().objectMapperWrapper();
    private Workspace workspace;
    private WidgetRepository widgetRepository;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.pathResolver.getPagesRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), "pages"));
        Mockito.when((Object)this.pathResolver.getWidgetsRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), "widgets"));
        Mockito.when((Object)this.pathResolver.getFragmentsRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), "fragments"));
        Mockito.when((Object)this.resource.getURI()).thenReturn((Object)this.temporaryFolder.toPath().resolve("widgets").toUri());
        Mockito.when((Object)this.resourceLoader.getResource(Matchers.anyString())).thenReturn((Object)this.resource);
        this.widgetRepository = new WidgetRepository(this.pathResolver.getWidgetsRepositoryPath(), this.widgetPersister, (JsonFileBasedLoader)new WidgetFileBasedLoader(this.jacksonObjectMapper), this.validator, (Watcher)Mockito.mock(Watcher.class));
        WidgetFileBasedLoader widgetLoader = new WidgetFileBasedLoader(this.jacksonObjectMapper);
        this.workspace = new Workspace(this.pathResolver, this.widgetRepository, widgetLoader, this.widgetDirectiveBuilder, this.fragmentDirectiveBuilder, this.resourceLoader, this.widgetAssetImporter);
        ReflectionTestUtils.setField((Object)this.workspace, (String)"modelVersion", (Object)CURRENT_MODEL_VERSION);
    }

    private void mockWidgetsBasePath(Path path) throws IOException {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getURI()).thenReturn((Object)path.toUri());
        Mockito.when((Object)this.resourceLoader.getResource("classpath:/widgets/")).thenReturn((Object)resource);
    }

    private void createWidget(String id, String content) throws IOException {
        Path labelFile = this.temporaryFolder.newFolderPath("widgets", id).resolve(id + ".json");
        byte[] fileContent = content.getBytes(StandardCharsets.UTF_8);
        Files.write(labelFile, fileContent, StandardOpenOption.CREATE);
    }

    private String contentOf(Path path) throws IOException {
        return new String(Files.readAllBytes(path));
    }

    @Test
    public void should_ensure_that_folders_page_and_widgets_are_created() throws Exception {
        this.mockWidgetsBasePath(this.temporaryFolder.toPath().resolve("widgets"));
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("widgets")).exists();
    }

    @Test
    public void should_not_throw_exception_when_a_folder_exist_before_init() throws Exception {
        this.temporaryFolder.newFolderPath("pages");
        Path widgetFolder = this.temporaryFolder.newFolderPath("widgets");
        this.mockWidgetsBasePath(widgetFolder);
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("widgets")).exists();
    }

    @Test
    public void should_copy_widget_to_widget_repository_folder() throws Exception {
        this.mockWidgetsBasePath(Paths.get("src/test/resources/workspace/widgets", new String[0]));
        this.workspace.initialize();
        Assertions.assertThat((Path)this.pathResolver.getWidgetsRepositoryPath().resolve("pbLabel/pbLabel.json")).exists();
        Assertions.assertThat((Path)this.pathResolver.getWidgetsRepositoryPath().resolve("pbText/pbText.json")).exists();
        Assertions.assertThat((Path)this.pathResolver.getWidgetsRepositoryPath().resolve("pbText/help.html")).exists();
        Assertions.assertThat((Path)this.pathResolver.getWidgetsRepositoryPath().resolve("pbMissingHelp/pbMissingHelp.json")).exists();
    }

    @Test
    public void should_not_copy_widget_file_if_it_is_already_in_widget_repository_with_same_version() throws Exception {
        this.mockWidgetsBasePath(Paths.get("src/test/resources/workspace/widgets", new String[0]));
        String existingWidgetContent = "{\"id\":\"pbLabel\", \"template\": \"<div>Hello</div>\", \"designerVersion\": \"2.0\"}";
        this.createWidget("pbLabel", existingWidgetContent);
        this.workspace.initialize();
        Assertions.assertThat((String)this.contentOf(this.pathResolver.getWidgetsRepositoryPath().resolve("pbLabel/pbLabel.json"))).isEqualTo((Object)existingWidgetContent);
    }

    @Test
    public void should_copy_widget_file_if_it_is_already_in_widget_repository_folder_with_a_former_version() throws Exception {
        this.mockWidgetsBasePath(Paths.get("src/test/resources/workspace/widgets", new String[0]));
        String existingWidgetContent = "{\"id\":\"pbLabel\", \"template\": \"<div>Hello</div>\", \"designerVersion\": \"1.0.1\"}";
        this.createWidget("pbLabel", existingWidgetContent);
        this.workspace.initialize();
        Assertions.assertThat((String)this.contentOf(this.pathResolver.getWidgetsRepositoryPath().resolve("pbLabel/pbLabel.json"))).isNotEqualTo((Object)existingWidgetContent);
    }

    @Test
    public void should_delete_page_reference_when_page_doesnt_exist_anymore_but_any_file_stay_on_filesystem() throws Exception {
        this.temporaryFolder.newFolderPath("pages", "myPageToRemove", "js");
        this.temporaryFolder.newFilePath("pages/.gitignore");
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve("myPageToRemove")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve(".gitignore")).exists();
    }

    @Test
    public void should_delete_only_js_folder_for_page_artifact_when_page_exist() throws Exception {
        this.temporaryFolder.newFolderPath("pages", "myPage", "js");
        this.temporaryFolder.newFilePath("pages/myPage/myPage.json");
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve("myPage")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve("myPage").resolve("js")).doesNotExist();
    }

    @Test
    public void should_keep_file_with_a_reference_on_workspace_when_cleanup_is_called() throws Exception {
        this.temporaryFolder.newFolderPath("pages", ".metadata");
        this.temporaryFolder.newFolderPath("pages", "myPage");
        this.temporaryFolder.newFilePath("pages/myPage/myPage.json");
        this.temporaryFolder.newFilePath("pages/.metadata/.index.json");
        this.temporaryFolder.newFilePath("pages/.metadata/myPage.json");
        this.temporaryFolder.newFilePath("pages/.metadata/oldestPage.json");
        this.workspace.cleanPageWorkspace();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve("myPage")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve("myPage").resolve("js")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve(".metadata").resolve(".index.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve(".metadata").resolve("oldestPage.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages").resolve(".metadata").resolve("myPage.json")).exists();
    }

    @Test
    public void should_ensure_that_folders_page_widgets_fragments_are_created() throws Exception {
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("pages")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("widgets")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments")).exists();
    }

    @Test
    public void should_not_throw_exception_when_a_folder_exist_before_init_with_fragment() throws Exception {
        this.temporaryFolder.newFolderPath("fragments");
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments")).exists();
    }

    @Test
    public void should_not_copy_widget_file_if_it_is_already_in_widget_repository_folder() throws Exception {
        Path labelDir = this.temporaryFolder.newFolderPath("widgets", "pbLabel");
        Path labelFile = labelDir.resolve("pbLabel.json");
        String existingWidget = "{\"id\":\"pbLabel\", \"template\": \"<div>Hello</div>\", \"designerVersion\": \"2.0\"}";
        byte[] fileContent = existingWidget.getBytes(StandardCharsets.UTF_8);
        Files.write(labelFile, fileContent, StandardOpenOption.CREATE);
        this.workspace.initialize();
        Assertions.assertThat((byte[])Files.readAllBytes(labelFile)).isEqualTo((Object)fileContent);
        Assertions.assertThat((Path)this.pathResolver.getWidgetsRepositoryPath().resolve("pbLabel/pbLabel.json")).exists();
    }

    @Test
    public void should_delete_fragment_reference_when_fragment_doesnt_exist_anymore_but_any_file_stay_on_filesystem() throws Exception {
        this.temporaryFolder.newFolderPath("fragments", "myFragment");
        this.temporaryFolder.newFilePath("fragments/myFragment/widgets-abcd487.min.js");
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve("myFragment")).doesNotExist();
    }

    @Test
    public void should_delete_only_js_file_for_fragment_artifact_when_fragment_descriptor_exist() throws Exception {
        this.temporaryFolder.newFolderPath("fragments", "myFragment");
        this.temporaryFolder.newFolderPath("fragments", ".metadata");
        this.temporaryFolder.newFilePath("fragments/myFragment/widgets-abcd487.min.js");
        this.temporaryFolder.newFilePath("fragments/myFragment/myFragment.json");
        this.temporaryFolder.newFilePath("fragments/.metadata/myFragment.json");
        this.temporaryFolder.newFilePath("fragments/.metadata/oldestFragment.json");
        this.temporaryFolder.newFilePath("fragments/.DSSTORE");
        this.temporaryFolder.newFilePath("fragments/.gitignore");
        this.workspace.initialize();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve("myFragment").resolve("widgets-abcd487.min.js")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve("myFragment")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve(".DSSTORE")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve(".gitignore")).exists();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve(".metadata").resolve("oldestFragment.json")).doesNotExist();
        Assertions.assertThat((Path)this.temporaryFolder.toPath().resolve("fragments").resolve(".metadata").resolve("myFragment.json")).exists();
    }
}

