
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbChart {

    private String cssClasses;
    private Boolean hidden = false;
    private PbChart.Type type = PbChart.Type.fromValue("Doughnut");
    private String data = "";
    private String labels = "";
    private String setLabels = "";
    private Boolean legendHidden = true;
    private String colors;
    private String options;

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public PbChart.Type getType() {
        return type;
    }

    public void setType(PbChart.Type type) {
        this.type = type;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getLabels() {
        return labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getSetLabels() {
        return setLabels;
    }

    public void setSetLabels(String setLabels) {
        this.setLabels = setLabels;
    }

    public Boolean getLegendHidden() {
        return legendHidden;
    }

    public void setLegendHidden(Boolean legendHidden) {
        this.legendHidden = legendHidden;
    }

    public String getColors() {
        return colors;
    }

    public void setColors(String colors) {
        this.colors = colors;
    }

    public String getOptions() {
        return options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public enum Type {

        DOUGHNUT("Doughnut"),
        PIE("Pie"),
        POLAR_AREA("PolarArea"),
        BAR("Bar"),
        LINE("Line"),
        RADAR("Radar");
        private final String value;
        private final static Map<String, PbChart.Type> CONSTANTS = new HashMap<String, PbChart.Type>();

        static {
            for (PbChart.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbChart.Type fromValue(String value) {
            PbChart.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
