
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbDateTimePicker {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean readOnly = false;
    private Boolean required = false;
    private Boolean labelHidden = false;
    private Boolean inlineInput = true;
    private String label = "Date and time";
    private PbDateTimePicker.LabelPosition labelPosition = PbDateTimePicker.LabelPosition.fromValue("top");
    private Double labelWidth = 4.0D;
    private PbDateTimePicker.WithTimeZone withTimeZone = PbDateTimePicker.WithTimeZone.fromValue("true");
    private String value;
    private String dateFormat = "MM/dd/yyyy";
    private String placeholder = "Enter a date (mm/dd/yyyy)";
    private String timeFormat = "h:mm:ss a";
    private String timePlaceholder = "Enter a time (h:mm:ss a)";
    private Boolean showToday = true;
    private String todayLabel = "Today";
    private Boolean showNow = true;
    private String nowLabel = "Now";

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Boolean getLabelHidden() {
        return labelHidden;
    }

    public void setLabelHidden(Boolean labelHidden) {
        this.labelHidden = labelHidden;
    }

    public Boolean getInlineInput() {
        return inlineInput;
    }

    public void setInlineInput(Boolean inlineInput) {
        this.inlineInput = inlineInput;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PbDateTimePicker.LabelPosition getLabelPosition() {
        return labelPosition;
    }

    public void setLabelPosition(PbDateTimePicker.LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public Double getLabelWidth() {
        return labelWidth;
    }

    public void setLabelWidth(Double labelWidth) {
        this.labelWidth = labelWidth;
    }

    public PbDateTimePicker.WithTimeZone getWithTimeZone() {
        return withTimeZone;
    }

    public void setWithTimeZone(PbDateTimePicker.WithTimeZone withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getTimeFormat() {
        return timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimePlaceholder() {
        return timePlaceholder;
    }

    public void setTimePlaceholder(String timePlaceholder) {
        this.timePlaceholder = timePlaceholder;
    }

    public Boolean getShowToday() {
        return showToday;
    }

    public void setShowToday(Boolean showToday) {
        this.showToday = showToday;
    }

    public String getTodayLabel() {
        return todayLabel;
    }

    public void setTodayLabel(String todayLabel) {
        this.todayLabel = todayLabel;
    }

    public Boolean getShowNow() {
        return showNow;
    }

    public void setShowNow(Boolean showNow) {
        this.showNow = showNow;
    }

    public String getNowLabel() {
        return nowLabel;
    }

    public void setNowLabel(String nowLabel) {
        this.nowLabel = nowLabel;
    }

    public enum LabelPosition {

        LEFT("left"),
        TOP("top");
        private final String value;
        private final static Map<String, PbDateTimePicker.LabelPosition> CONSTANTS = new HashMap<String, PbDateTimePicker.LabelPosition>();

        static {
            for (PbDateTimePicker.LabelPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private LabelPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbDateTimePicker.LabelPosition fromValue(String value) {
            PbDateTimePicker.LabelPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum WithTimeZone {

        FALSE("false"),
        TRUE("true");
        private final String value;
        private final static Map<String, PbDateTimePicker.WithTimeZone> CONSTANTS = new HashMap<String, PbDateTimePicker.WithTimeZone>();

        static {
            for (PbDateTimePicker.WithTimeZone c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private WithTimeZone(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbDateTimePicker.WithTimeZone fromValue(String value) {
            PbDateTimePicker.WithTimeZone constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
