
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbTabsContainer {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean vertical = false;
    private PbTabsContainer.Type type = PbTabsContainer.Type.fromValue("tabs");

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getVertical() {
        return vertical;
    }

    public void setVertical(Boolean vertical) {
        this.vertical = vertical;
    }

    public PbTabsContainer.Type getType() {
        return type;
    }

    public void setType(PbTabsContainer.Type type) {
        this.type = type;
    }

    public enum Type {

        TABS("tabs"),
        PILLS("pills");
        private final String value;
        private final static Map<String, PbTabsContainer.Type> CONSTANTS = new HashMap<String, PbTabsContainer.Type>();

        static {
            for (PbTabsContainer.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbTabsContainer.Type fromValue(String value) {
            PbTabsContainer.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
