
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbDataTable {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean allowHTML = true;
    private String headers = "";
    private PbDataTable.Type type = PbDataTable.Type.fromValue("Bonita API");
    private String apiUrl = "../API/";
    private String params;
    private String content;
    private String columnsKey;
    private String sortColumns;
    private String selectedRow;
    private Double pageSize = 10.0D;
    private String filter;
    private Boolean striped = true;
    private Boolean condensed = false;
    private Boolean bordered = false;

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getAllowHTML() {
        return allowHTML;
    }

    public void setAllowHTML(Boolean allowHTML) {
        this.allowHTML = allowHTML;
    }

    public String getHeaders() {
        return headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public PbDataTable.Type getType() {
        return type;
    }

    public void setType(PbDataTable.Type type) {
        this.type = type;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getColumnsKey() {
        return columnsKey;
    }

    public void setColumnsKey(String columnsKey) {
        this.columnsKey = columnsKey;
    }

    public String getSortColumns() {
        return sortColumns;
    }

    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    public String getSelectedRow() {
        return selectedRow;
    }

    public void setSelectedRow(String selectedRow) {
        this.selectedRow = selectedRow;
    }

    public Double getPageSize() {
        return pageSize;
    }

    public void setPageSize(Double pageSize) {
        this.pageSize = pageSize;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Boolean getStriped() {
        return striped;
    }

    public void setStriped(Boolean striped) {
        this.striped = striped;
    }

    public Boolean getCondensed() {
        return condensed;
    }

    public void setCondensed(Boolean condensed) {
        this.condensed = condensed;
    }

    public Boolean getBordered() {
        return bordered;
    }

    public void setBordered(Boolean bordered) {
        this.bordered = bordered;
    }

    public enum Type {

        VARIABLE("Variable"),
        BONITA_API("Bonita API");
        private final String value;
        private final static Map<String, PbDataTable.Type> CONSTANTS = new HashMap<String, PbDataTable.Type>();

        static {
            for (PbDataTable.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbDataTable.Type fromValue(String value) {
            PbDataTable.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
