
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbFileViewer {

    private String cssClasses;
    private Boolean hidden = false;
    private PbFileViewer.Type type = PbFileViewer.Type.fromValue("Process document");
    private String url = "";
    private String document = "";
    private Boolean showPreview = true;

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public PbFileViewer.Type getType() {
        return type;
    }

    public void setType(PbFileViewer.Type type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDocument() {
        return document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public Boolean getShowPreview() {
        return showPreview;
    }

    public void setShowPreview(Boolean showPreview) {
        this.showPreview = showPreview;
    }

    public enum Type {

        PROCESS_DOCUMENT("Process document"),
        URL("URL");
        private final String value;
        private final static Map<String, PbFileViewer.Type> CONSTANTS = new HashMap<String, PbFileViewer.Type>();

        static {
            for (PbFileViewer.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbFileViewer.Type fromValue(String value) {
            PbFileViewer.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
