
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbInput {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean required = false;
    private Double minLength;
    private Double maxLength;
    private Boolean readOnly = false;
    private Boolean labelHidden = false;
    private String label = "Default label";
    private PbInput.LabelPosition labelPosition = PbInput.LabelPosition.fromValue("top");
    private Double labelWidth = 4.0D;
    private String placeholder;
    private String value;
    private PbInput.Type type = PbInput.Type.fromValue("text");
    private Double min;
    private Double max;
    private Double step = 1.0D;

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Double getMinLength() {
        return minLength;
    }

    public void setMinLength(Double minLength) {
        this.minLength = minLength;
    }

    public Double getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Double maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getLabelHidden() {
        return labelHidden;
    }

    public void setLabelHidden(Boolean labelHidden) {
        this.labelHidden = labelHidden;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PbInput.LabelPosition getLabelPosition() {
        return labelPosition;
    }

    public void setLabelPosition(PbInput.LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public Double getLabelWidth() {
        return labelWidth;
    }

    public void setLabelWidth(Double labelWidth) {
        this.labelWidth = labelWidth;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PbInput.Type getType() {
        return type;
    }

    public void setType(PbInput.Type type) {
        this.type = type;
    }

    public Double getMin() {
        return min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMax() {
        return max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public Double getStep() {
        return step;
    }

    public void setStep(Double step) {
        this.step = step;
    }

    public enum LabelPosition {

        LEFT("left"),
        TOP("top");
        private final String value;
        private final static Map<String, PbInput.LabelPosition> CONSTANTS = new HashMap<String, PbInput.LabelPosition>();

        static {
            for (PbInput.LabelPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private LabelPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbInput.LabelPosition fromValue(String value) {
            PbInput.LabelPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum Type {

        TEXT("text"),
        NUMBER("number"),
        EMAIL("email"),
        PASSWORD("password");
        private final String value;
        private final static Map<String, PbInput.Type> CONSTANTS = new HashMap<String, PbInput.Type>();

        static {
            for (PbInput.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbInput.Type fromValue(String value) {
            PbInput.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
