
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbRichTextarea {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean readOnly = false;
    private Boolean required = false;
    private Double minLength;
    private Double maxLength;
    private Boolean labelHidden = false;
    private String label = "Default label";
    private PbRichTextarea.LabelPosition labelPosition = PbRichTextarea.LabelPosition.fromValue("top");
    private Double labelWidth = 4.0D;
    private String value;
    private String toolbarsGrp1 = "";
    private String toolbarsGrp2 = "";
    private String toolbarsGrp3 = "";
    private String toolbarsGrp4 = "";

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Double getMinLength() {
        return minLength;
    }

    public void setMinLength(Double minLength) {
        this.minLength = minLength;
    }

    public Double getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Double maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getLabelHidden() {
        return labelHidden;
    }

    public void setLabelHidden(Boolean labelHidden) {
        this.labelHidden = labelHidden;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PbRichTextarea.LabelPosition getLabelPosition() {
        return labelPosition;
    }

    public void setLabelPosition(PbRichTextarea.LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public Double getLabelWidth() {
        return labelWidth;
    }

    public void setLabelWidth(Double labelWidth) {
        this.labelWidth = labelWidth;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getToolbarsGrp1() {
        return toolbarsGrp1;
    }

    public void setToolbarsGrp1(String toolbarsGrp1) {
        this.toolbarsGrp1 = toolbarsGrp1;
    }

    public String getToolbarsGrp2() {
        return toolbarsGrp2;
    }

    public void setToolbarsGrp2(String toolbarsGrp2) {
        this.toolbarsGrp2 = toolbarsGrp2;
    }

    public String getToolbarsGrp3() {
        return toolbarsGrp3;
    }

    public void setToolbarsGrp3(String toolbarsGrp3) {
        this.toolbarsGrp3 = toolbarsGrp3;
    }

    public String getToolbarsGrp4() {
        return toolbarsGrp4;
    }

    public void setToolbarsGrp4(String toolbarsGrp4) {
        this.toolbarsGrp4 = toolbarsGrp4;
    }

    public enum LabelPosition {

        LEFT("left"),
        TOP("top");
        private final String value;
        private final static Map<String, PbRichTextarea.LabelPosition> CONSTANTS = new HashMap<String, PbRichTextarea.LabelPosition>();

        static {
            for (PbRichTextarea.LabelPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private LabelPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbRichTextarea.LabelPosition fromValue(String value) {
            PbRichTextarea.LabelPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
