
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbSaveButton {

    private String cssClasses;
    private Boolean hidden = false;
    private String label = "Save draft";
    private PbSaveButton.Alignment alignment = PbSaveButton.Alignment.fromValue("left");
    private PbSaveButton.ButtonStyle buttonStyle = PbSaveButton.ButtonStyle.fromValue("default");
    private String formInput = "formInput";

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PbSaveButton.Alignment getAlignment() {
        return alignment;
    }

    public void setAlignment(PbSaveButton.Alignment alignment) {
        this.alignment = alignment;
    }

    public PbSaveButton.ButtonStyle getButtonStyle() {
        return buttonStyle;
    }

    public void setButtonStyle(PbSaveButton.ButtonStyle buttonStyle) {
        this.buttonStyle = buttonStyle;
    }

    public String getFormInput() {
        return formInput;
    }

    public void setFormInput(String formInput) {
        this.formInput = formInput;
    }

    public enum Alignment {

        LEFT("left"),
        CENTER("center"),
        RIGHT("right");
        private final String value;
        private final static Map<String, PbSaveButton.Alignment> CONSTANTS = new HashMap<String, PbSaveButton.Alignment>();

        static {
            for (PbSaveButton.Alignment c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Alignment(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbSaveButton.Alignment fromValue(String value) {
            PbSaveButton.Alignment constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ButtonStyle {

        DEFAULT("default"),
        PRIMARY("primary"),
        SUCCESS("success"),
        INFO("info"),
        WARNING("warning"),
        DANGER("danger"),
        LINK("link");
        private final String value;
        private final static Map<String, PbSaveButton.ButtonStyle> CONSTANTS = new HashMap<String, PbSaveButton.ButtonStyle>();

        static {
            for (PbSaveButton.ButtonStyle c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ButtonStyle(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbSaveButton.ButtonStyle fromValue(String value) {
            PbSaveButton.ButtonStyle constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
