
package org.bonitasoft.web.designer.generator.widgets;

import java.util.HashMap;
import java.util.Map;

public class PbTextarea {

    private String cssClasses;
    private Boolean hidden = false;
    private Boolean readOnly = false;
    private Boolean required = false;
    private Double minLength;
    private Double maxLength;
    private Boolean labelHidden = false;
    private String label = "Default label";
    private PbTextarea.LabelPosition labelPosition = PbTextarea.LabelPosition.fromValue("top");
    private Double labelWidth = 4.0D;
    private String value;

    public String getCssClasses() {
        return cssClasses;
    }

    public void setCssClasses(String cssClasses) {
        this.cssClasses = cssClasses;
    }

    public Boolean getHidden() {
        return hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getReadOnly() {
        return readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public Double getMinLength() {
        return minLength;
    }

    public void setMinLength(Double minLength) {
        this.minLength = minLength;
    }

    public Double getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Double maxLength) {
        this.maxLength = maxLength;
    }

    public Boolean getLabelHidden() {
        return labelHidden;
    }

    public void setLabelHidden(Boolean labelHidden) {
        this.labelHidden = labelHidden;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public PbTextarea.LabelPosition getLabelPosition() {
        return labelPosition;
    }

    public void setLabelPosition(PbTextarea.LabelPosition labelPosition) {
        this.labelPosition = labelPosition;
    }

    public Double getLabelWidth() {
        return labelWidth;
    }

    public void setLabelWidth(Double labelWidth) {
        this.labelWidth = labelWidth;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public enum LabelPosition {

        LEFT("left"),
        TOP("top");
        private final String value;
        private final static Map<String, PbTextarea.LabelPosition> CONSTANTS = new HashMap<String, PbTextarea.LabelPosition>();

        static {
            for (PbTextarea.LabelPosition c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private LabelPosition(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static PbTextarea.LabelPosition fromValue(String value) {
            PbTextarea.LabelPosition constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
