/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@ContextConfiguration(classes={DesignerConfig.class})
@WebAppConfiguration(value="file:target/test-classes")
public class DesignerConfigTest {
    private static Properties prop = new Properties();

    @BeforeClass
    public static void init() throws IOException {
        prop.load(DesignerConfigTest.class.getClassLoader().getResourceAsStream("application.properties"));
        System.setProperty("repository.pages", prop.getProperty("builddirectory") + "/test-classes/workspace/pages");
        System.setProperty("repository.widgets", prop.getProperty("builddirectory") + "/test-classes/workspace/widgets");
        System.setProperty("repository.fragments", prop.getProperty("builddirectory") + "/test-classes/workspace/fragments");
    }

    @Test
    public void loadConfig() throws IOException {
        Assertions.assertThat((boolean)Files.exists(Paths.get(prop.getProperty("builddirectory") + "/test-classes/i18n/simple.json", new String[0]), new LinkOption[0]));
        Assertions.assertThat((boolean)Files.exists(Paths.get(prop.getProperty("builddirectory") + "/test-classes/workspace/pages", new String[0]), new LinkOption[0]));
        Assertions.assertThat((boolean)Files.exists(Paths.get(prop.getProperty("builddirectory") + "/test-classes/workspace/widgets", new String[0]), new LinkOption[0]));
        Assertions.assertThat((boolean)Files.exists(Paths.get(prop.getProperty("builddirectory") + "/test-classes/workspace/fragments", new String[0]), new LinkOption[0]));
    }
}

