/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import javax.servlet.http.HttpServletResponse;
import org.bonitasoft.web.designer.controller.ExportController;
import org.bonitasoft.web.designer.controller.export.Exporter;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.utils.UIDesignerMockMvcBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

@RunWith(value=MockitoJUnitRunner.class)
public class ExportControllerTest {
    private MockMvc mockMvc;
    @Mock
    private Exporter<Page> pageExporter;
    @Mock
    private Exporter<Widget> widgetExporter;
    @Mock
    private Exporter<Fragment> fragmentExporter;
    private ExportController exportController;

    @Before
    public void setUp() {
        this.exportController = new ExportController(this.pageExporter, this.widgetExporter, this.fragmentExporter);
        this.mockMvc = UIDesignerMockMvcBuilder.mockServer(this.exportController).build();
    }

    @Test
    public void should_export_a_page() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/export/page/a-page", (Object[])new Object[0]));
        ((Exporter)Mockito.verify(this.pageExporter)).handleFileExport((String)Matchers.eq((Object)"a-page"), (HttpServletResponse)Matchers.any(HttpServletResponse.class));
    }

    @Test
    public void should_export_a_widget() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/export/widget/a-widget", (Object[])new Object[0]));
        ((Exporter)Mockito.verify(this.widgetExporter)).handleFileExport((String)Matchers.eq((Object)"a-widget"), (HttpServletResponse)Matchers.any(HttpServletResponse.class));
    }

    @Test
    public void should_export_a_fragment() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/export/fragment/a-fragment", (Object[])new Object[0]));
        ((Exporter)Mockito.verify(this.fragmentExporter)).handleFileExport((String)Matchers.eq((Object)"a-fragment"), (HttpServletResponse)Matchers.any(HttpServletResponse.class));
    }
}

