/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.mocks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.repository.FragmentRepository;
import org.bonitasoft.web.designer.repository.JsonFileBasedLoader;
import org.mockito.Mockito;

public class FragmentImportMock {
    private static final String FRAGMENTS_FOLDER = "fragments";
    private FragmentRepository fragmentRepository;
    private JsonFileBasedLoader<Fragment> fragmentLoader;
    private Path unzippedPath;
    private List<Fragment> fragments = new ArrayList<Fragment>();

    public FragmentImportMock(Path unzippedPath, FragmentRepository fragmentRepository, JsonFileBasedLoader<Fragment> fragmentLoader) throws IOException {
        this.fragmentRepository = fragmentRepository;
        this.fragmentLoader = fragmentLoader;
        this.unzippedPath = unzippedPath;
    }

    public List<Fragment> mockFragmentsAsAddedDependencies() throws IOException {
        Files.createDirectories(this.unzippedPath.resolve(FRAGMENTS_FOLDER), new FileAttribute[0]);
        List<Fragment> fragments = Arrays.asList(FragmentBuilder.aFragment().id("aFragment").build(), FragmentBuilder.aFragment().id("anotherFragment").build());
        this.fragments.addAll(fragments);
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.when((Object)this.fragmentLoader.getAll(this.unzippedPath.resolve(FRAGMENTS_FOLDER))).thenReturn(this.fragments);
        return fragments;
    }

    public List<Fragment> mockFragmentsAsOverriddenDependencies() throws IOException {
        Files.createDirectories(this.unzippedPath.resolve(FRAGMENTS_FOLDER), new FileAttribute[0]);
        List<Fragment> fragments = Arrays.asList(FragmentBuilder.aFragment().id("anExistingFragment").build(), FragmentBuilder.aFragment().id("anotherExistingFragment").build());
        this.fragments.addAll(fragments);
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.when((Object)this.fragmentLoader.getAll(this.unzippedPath.resolve(FRAGMENTS_FOLDER))).thenReturn(this.fragments);
        Mockito.when((Object)this.fragmentRepository.exists("anotherExistingFragment")).thenReturn((Object)true);
        Mockito.when((Object)this.fragmentRepository.exists("anExistingFragment")).thenReturn((Object)true);
        return fragments;
    }

    public Fragment mockFragmentToBeImported() {
        Fragment fragment = FragmentBuilder.aFragment().id("aFragment").build();
        Mockito.when((Object)this.fragmentLoader.load(this.unzippedPath.resolve("fragment.json"))).thenReturn((Object)fragment);
        return fragment;
    }
}

