/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.utils;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.utils.HttpFile;
import org.junit.Test;

public class HttpFileTest {
    @Test(expected=NullPointerException.class)
    public void should_throw_NullPointerException_when_filename_is_null() {
        HttpFile.getOriginalFilename(null);
    }

    @Test
    public void should_find_filename_in_full_linux_path() {
        Assertions.assertThat((String)HttpFile.getOriginalFilename((String)"/tmp/test/myfile.js")).isEqualTo((Object)"myfile.js");
    }

    @Test
    public void should_find_filename_in_full_windows_path() {
        Assertions.assertThat((String)HttpFile.getOriginalFilename((String)"C:\\Users\\frontend\\myfile.js")).isEqualTo((Object)"myfile.js");
    }

    @Test
    public void should_find_filename_when_no_full_path() {
        Assertions.assertThat((String)HttpFile.getOriginalFilename((String)"myfile.js")).isEqualTo((Object)"myfile.js");
    }
}

