/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.livebuild;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.livebuild.ObserverFactory;
import org.bonitasoft.web.designer.livebuild.PathListener;
import org.bonitasoft.web.designer.livebuild.PathListenerStub;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ObserverFactoryTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path monitoredFolder;
    private ObserverFactory factory;
    private PathListenerStub listener;

    @Before
    public void setUp() throws Exception {
        this.monitoredFolder = this.temporaryFolder.newFolder("r\u00e9pertoire avec un nom b1z@re").toPath();
        this.factory = new ObserverFactory();
        this.listener = new PathListenerStub();
    }

    @Test
    public void should_create_an_observer_that_notify_when_a_file_is_created() throws Exception {
        FileAlterationObserver observer = this.factory.create(this.monitoredFolder, (PathListener)this.listener);
        Path aFile = Files.write(this.monitoredFolder.resolve("aFile"), "coucou".getBytes(), new OpenOption[0]);
        observer.checkAndNotify();
        Assertions.assertThat(this.listener.getChanged()).containsExactly((Object[])new Path[]{aFile});
    }

    @Test
    public void should_create_an_observer_that_notify_when_a_file_is_modified() throws Exception {
        Files.write(this.monitoredFolder.resolve("aFile"), "coucou".getBytes(), new OpenOption[0]);
        FileAlterationObserver observer = this.factory.create(this.monitoredFolder, (PathListener)this.listener);
        Files.write(this.monitoredFolder.resolve("aFile"), "modified content".getBytes(), new OpenOption[0]);
        observer.checkAndNotify();
        Assertions.assertThat(this.listener.getChanged()).containsExactly((Object[])new Path[]{this.monitoredFolder.resolve("aFile")});
    }
}

