/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.rendering;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.rendering.DirectiveFileGenerator;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.utils.rule.TemporaryFolder;
import org.bonitasoft.web.designer.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DirectiveFileGeneratorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DirectiveFileGenerator generator;
    @Mock
    private WorkspacePathResolver pathResolver;
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private WidgetIdVisitor widgetIdVisitor;

    @Before
    public void beforeEach() {
        this.generator = new DirectiveFileGenerator(this.pathResolver, this.widgetRepository, this.widgetIdVisitor);
        Mockito.when((Object)this.pathResolver.getPagesRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), new String[0]));
        Mockito.when((Object)this.pathResolver.getWidgetsRepositoryPath()).thenReturn((Object)Paths.get(this.temporaryFolder.toPath().toString(), new String[0]));
    }

    @Test
    public void should_list_all_widgets_except_container_used_in_page() throws Exception {
        Page page = PageBuilder.aPage().with(new Element[]{ContainerBuilder.aContainer().build()}).build();
        this.mockWidgetIdVisitorAndWidgetRepository(page, "pbLabel", "paragraph", "pbContainer");
        List widgesFiles = this.generator.getWidgetsFilesUsedInPage((Previewable)page);
        Assertions.assertThat((List)widgesFiles).containsOnly((Object[])new Path[]{this.temporaryFolder.toPath().resolve("pbLabel").resolve("pbLabel.js"), this.temporaryFolder.toPath().resolve("paragraph").resolve("paragraph.js")});
        Assertions.assertThat((List)widgesFiles).doesNotContain((Object[])new Path[]{this.temporaryFolder.toPath().resolve("pbContainer").resolve("pbContainer.js")});
    }

    @Test
    public void should_get_file_name_of_concatenation_widgets_directives_file_who_was_use_in_page() throws Exception {
        Page page = PageBuilder.aPage().build();
        this.initWidgetsFileWhoUsedInPage(page);
        this.mockWidgetIdVisitorAndWidgetRepository(page, "pbLabel", "paragraph");
        Path pagePath = this.temporaryFolder.toPath().resolve("pages").resolve(page.getId());
        String filename = this.generator.generateAllDirectivesFilesInOne((Previewable)page, pagePath);
        Assertions.assertThat((String)filename).isEqualTo((Object)"widgets-f66d6f4cc38b2259ec29fa16e9f171251cd3d346.min.js");
    }

    @Test
    public void should_concatenate_and_minify_widgets_directives_file_who_was_use_in_page() throws Exception {
        Page page = PageBuilder.aPage().build();
        this.initFilesForConcatAndMinify(page);
        this.mockWidgetIdVisitorAndWidgetRepository(page, "pbLabel", "paragraph");
        Path path = this.temporaryFolder.toPath().resolve("pages").resolve(page.getId());
        String expected = "\nList<String>filename=getWidgetsFilesUsedInPage(previewable);byte[]content=getConcatenationWidgetsDirectives(filename);file2";
        String filename = this.generator.generateAllDirectivesFilesInOne((Previewable)page, path);
        Assertions.assertThat((String)new String(Files.readAllBytes(path.resolve(filename)), "UTF-8")).isEqualTo((Object)expected);
        Assertions.assertThat((String)filename).isEqualTo((Object)"widgets-0f2d4ba1fa1992794df3dca7a9b8e4ec735b4746.min.js");
    }

    private void initWidgetsFileWhoUsedInPage(Page page) throws IOException {
        this.temporaryFolder.newFolder("pbLabel");
        this.temporaryFolder.newFolder("paragraph");
        this.temporaryFolder.newFolder(new String[]{"pages", page.getId()});
        com.google.common.io.Files.write((byte[])"file1".getBytes(), (File)this.temporaryFolder.newFile("pbLabel/pbLabel.js"));
        com.google.common.io.Files.write((byte[])"file2".getBytes(), (File)this.temporaryFolder.newFile("paragraph/paragraph.js"));
    }

    private void mockWidgetIdVisitorAndWidgetRepository(Page page, String ... ids) {
        HashSet<String> widgetIds = new HashSet<String>(Arrays.asList(ids));
        List widgets = Arrays.asList(ids).stream().map(id -> WidgetBuilder.aWidget().id((String)id).build()).collect(Collectors.toList());
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(widgetIds);
        Mockito.when((Object)this.widgetRepository.getByIds(widgetIds)).thenReturn(widgets);
    }

    private void initFilesForConcatAndMinify(Page page) throws IOException {
        this.temporaryFolder.newFolder("pbLabel");
        this.temporaryFolder.newFolder("paragraph");
        this.temporaryFolder.newFolder(new String[]{"pages", page.getId()});
        com.google.common.io.Files.write((byte[])" List<String> filename = getWidgetsFilesUsedInPage(previewable);\n byte[] content = getConcatenationWidgetsDirectives(filename);".getBytes(), (File)this.temporaryFolder.newFile("pbLabel/pbLabel.js"));
        com.google.common.io.Files.write((byte[])"file2".getBytes(), (File)this.temporaryFolder.newFile("paragraph/paragraph.js"));
    }
}

