/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.studio.workspace;

import com.github.dreamhead.moco.HttpResponseSetting;
import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Runner;
import com.github.dreamhead.moco.resource.Resource;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.studio.workspace.LockStatus;
import org.bonitasoft.web.designer.studio.workspace.LockedResourceException;
import org.bonitasoft.web.designer.studio.workspace.ResourceNotFoundException;
import org.bonitasoft.web.designer.studio.workspace.RestClient;
import org.bonitasoft.web.designer.studio.workspace.RestClientProperties;
import org.bonitasoft.web.designer.studio.workspace.StudioWorkspaceResourceHandler;
import org.bonitasoft.web.designer.studio.workspace.WorkspaceResourceEvent;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class StudioWorkspaceResourceHandlerTest {
    private StudioWorkspaceResourceHandler studioWorkspaceResourceHandler;
    private RestClient restClient;
    private static Runner runner;
    private HttpServer server;
    private Path filePath;
    @InjectMocks
    private RestClientProperties restClientProperties;
    @Mock
    private Environment env;

    @Before
    public void setUp() throws Exception {
        if (this.server == null) {
            this.server = Moco.httpserver((MocoConfig[])new MocoConfig[0]);
            runner = Runner.runner((HttpServer)this.server);
            runner.start();
        }
        this.restClient = new RestClient(new RestTemplate(), this.restClientProperties);
        this.filePath = Paths.get("path", "to", "file");
        this.studioWorkspaceResourceHandler = new StudioWorkspaceResourceHandler(this.restClient);
        Mockito.when((Object)this.env.getProperty("workspace.api.rest.url")).thenReturn((Object)("http://localhost:" + this.server.port() + "/workspace"));
    }

    @AfterClass
    public static void stopServer() throws Exception {
        if (runner != null) {
            runner.stop();
        }
    }

    @Test
    public void should_doPost_doNothing_if_rest_client_is_not_configured() throws Exception {
        Mockito.when((Object)this.env.getProperty("workspace.api.rest.url")).thenReturn(null);
        this.studioWorkspaceResourceHandler.doPost(this.filePath, WorkspaceResourceEvent.POST_CLOSE);
    }

    @Test
    public void should_doGet_doNothing_if_rest_client_is_not_configured() throws Exception {
        Mockito.when((Object)this.env.getProperty("workspace.api.rest.url")).thenReturn(null);
        this.studioWorkspaceResourceHandler.doGet(this.filePath, "lockStatus");
    }

    @Test
    public void should_preOpen_post_filePath_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/PRE_OPEN")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.preOpen(this.filePath);
    }

    @Test(expected=LockedResourceException.class)
    public void should_preOpen_throw_a_LockedResourceException_if_status_is_locked() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/PRE_OPEN")))).response(Moco.status((int)HttpStatus.LOCKED.value()));
        this.studioWorkspaceResourceHandler.preOpen(this.filePath);
    }

    @Test(expected=ResourceNotFoundException.class)
    public void should_preOpen_throw_a_ResourceNotFoundException_if_status_is_NOT_FOUND() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/PRE_OPEN")))).response(Moco.status((int)HttpStatus.NOT_FOUND.value()));
        this.studioWorkspaceResourceHandler.preOpen(this.filePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_doPost_throw_an_IllegalArgumentException_if_actionEvent_is_null() throws Exception {
        Path filePath = Paths.get("path", "to", "file");
        this.studioWorkspaceResourceHandler.doPost(filePath, null);
    }

    @Test
    public void should_postClose_post_filePath_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/POST_CLOSE")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.postClose(this.filePath);
    }

    @Test
    public void should_delete_post_filePath_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/DELETE")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.delete(this.filePath);
    }

    @Test
    public void should_postDelete_post_filePath_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/POST_DELETE")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.postDelete(this.filePath);
    }

    @Test
    public void should_postSave_post_filePath_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/POST_SAVE")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.postSave(this.filePath);
    }

    @Test
    public void should_preImport_post_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/PRE_IMPORT")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.preImport();
    }

    @Test
    public void should_postImport_post_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)"/workspace/POST_IMPORT")))).response(Moco.status((int)HttpStatus.OK.value()));
        this.studioWorkspaceResourceHandler.postImport();
    }

    @Test
    public void should_getLockStatus_get_to_workspace_rest_api() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)("/workspace/" + URLEncoder.encode(this.filePath.toString(), "UTF-8") + "/lockStatus"))))).response(LockStatus.LOCKED_BY_ME.name());
        LockStatus lockStatus = this.studioWorkspaceResourceHandler.getLockStatus(this.filePath);
        Assertions.assertThat((Comparable)lockStatus).isEqualTo((Object)LockStatus.LOCKED_BY_ME);
    }

    @Test
    public void should_getLockStatus_return_UNLOCKED_as_default_value() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)("/workspace/" + URLEncoder.encode(this.filePath.toString(), "UTF-8") + "/lockStatus"))))).response(Moco.status((int)HttpStatus.OK.value()));
        LockStatus lockStatus = this.studioWorkspaceResourceHandler.getLockStatus(this.filePath);
        Assertions.assertThat((Comparable)lockStatus).isEqualTo((Object)LockStatus.UNLOCKED);
    }

    @Test(expected=ResourceNotFoundException.class)
    public void should_getLockStatus_throw_a_ResourceNotFoundException_if_status_NOT_FOUND() throws Exception {
        ((HttpResponseSetting)this.server.request(Moco.by((Resource)Moco.uri((String)("/workspace/" + URLEncoder.encode(this.filePath.toString(), "UTF-8") + "/lockStatus"))))).response(Moco.status((int)HttpStatus.NOT_FOUND.value()));
        this.studioWorkspaceResourceHandler.getLockStatus(this.filePath);
    }
}

