/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.config.WebMvcConfiguration;
import org.bonitasoft.web.designer.controller.ResourceControllerAdvice;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class TestWebMvcConfigurationSupport
extends WebMvcConfigurationSupport {
    private DesignerConfig config;

    public TestWebMvcConfigurationSupport(DesignerConfig config) {
        this.config = config;
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.registerSingleton("resourceControllerAdvice", ResourceControllerAdvice.class);
        this.setApplicationContext((ApplicationContext)applicationContext);
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        Collections.addAll(converters, this.createMessageConverters());
    }

    public HttpMessageConverter<?>[] createMessageConverters() {
        WebMvcConfiguration webMvcConfiguration = new WebMvcConfiguration();
        ReflectionTestUtils.setField((Object)webMvcConfiguration, (String)"objectMapper", (Object)this.config.objectMapper());
        ArrayList converters = new ArrayList();
        webMvcConfiguration.configureMessageConverters(converters);
        return converters.toArray(new HttpMessageConverter[converters.size()]);
    }
}

