/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.rule;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.rules.ExternalResource;

public class TestResource
extends ExternalResource {
    String packageName;
    InputStream stream;

    public TestResource(Class<?> aClass) {
        this.packageName = aClass.getPackage().getName();
    }

    public String load(String fileName) {
        String filePath = "/" + this.packageName.replace(".", "/") + "/" + fileName;
        try {
            this.stream = ((Object)((Object)this)).getClass().getResourceAsStream(filePath);
            if (this.stream == null) {
                throw new Error(String.format("Unable to load test resource %s", filePath));
            }
            return IOUtils.toString((InputStream)this.stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new Error(String.format("Unable to load test resource %s", filePath), e);
        }
    }

    protected void before() throws Throwable {
        super.before();
        this.stream = ((Object)((Object)this)).getClass().getResourceAsStream(this.packageName);
    }

    protected void after() {
        IOUtils.closeQuietly((InputStream)this.stream);
        super.after();
    }
}

