/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.workspace.CopyContentIfNotExistsVisitor;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CopyContentIfNotExistsVisitorTest {
    @Rule
    public TemporaryFolder directory = new TemporaryFolder();
    File source;
    File destination;
    CopyContentIfNotExistsVisitor visitor;

    @Before
    public void setup() throws Exception {
        this.source = this.directory.newFolder("source");
        this.destination = this.directory.newFolder("destination");
        this.visitor = new CopyContentIfNotExistsVisitor(this.source.toPath(), this.destination.toPath());
    }

    @Test
    public void should_create_given_directory() throws Exception {
        this.visitor.preVisitDirectory(this.source.toPath().resolve("widgets"), null);
        Assertions.assertThat((boolean)Files.exists(this.destination.toPath().resolve("widgets"), new LinkOption[0])).isTrue();
    }

    @Test
    public void should_not_create_given_directory_if_it_already_exist() throws Exception {
        Files.createDirectories(this.destination.toPath().resolve("widgets"), new FileAttribute[0]);
        this.visitor.preVisitDirectory(this.source.toPath().resolve("widgets"), null);
        Assertions.assertThat((boolean)Files.exists(this.destination.toPath().resolve("widgets"), new LinkOption[0])).isTrue();
    }

    @Test
    public void should_copy_given_file_from_source_directory() throws Exception {
        Files.write(this.source.toPath().resolve("pbButton.json"), "contents".getBytes(), new OpenOption[0]);
        this.visitor.visitFile(this.source.toPath().resolve("pbButton.json"), null);
        Assertions.assertThat((byte[])Files.readAllBytes(this.destination.toPath().resolve("pbButton.json"))).isEqualTo((Object)"contents".getBytes());
    }

    @Test
    public void should_not_copy_given_file_from_source_directory_if_it_already_exist() throws Exception {
        Files.write(this.source.toPath().resolve("pbButton.json"), "contents from source".getBytes(), new OpenOption[0]);
        Files.write(this.destination.toPath().resolve("pbButton.json"), "contents from destination".getBytes(), new OpenOption[0]);
        this.visitor.visitFile(this.source.toPath().resolve("pbButton.json"), null);
        Assertions.assertThat((byte[])Files.readAllBytes(this.destination.toPath().resolve("pbButton.json"))).isEqualTo((Object)"contents from destination".getBytes());
    }
}

