/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.config.DesignerConfig;
import org.bonitasoft.web.designer.livebuild.PathListener;
import org.bonitasoft.web.designer.livebuild.Watcher;
import org.bonitasoft.web.designer.model.JacksonObjectMapper;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.rendering.TemplateEngine;
import org.bonitasoft.web.designer.visitor.HtmlBuilderVisitor;
import org.bonitasoft.web.designer.workspace.FragmentDirectiveBuilder;
import org.bonitasoft.web.designer.workspace.HtmlSanitizer;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FragmentDirectiveBuilderTest {
    @Rule
    public TemporaryFolder repositoryDirectory = new TemporaryFolder();
    @Mock
    private Watcher watcher;
    private JacksonObjectMapper objectMapper = new DesignerConfig().objectMapperWrapper();
    @Mock
    private HtmlBuilderVisitor htmlBuilderVisitor;
    private HtmlSanitizer htmlSanitizer = new HtmlSanitizer();
    @InjectMocks
    private FragmentDirectiveBuilder fragmentDirectiveBuilder;
    private File fragmentFile;
    private Fragment fragment;
    private TemplateEngine htmlBuilder = new TemplateEngine("fragmentDirectiveTemplate.hbs.js");

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.fragmentDirectiveBuilder = new FragmentDirectiveBuilder(this.watcher, this.objectMapper, this.htmlBuilderVisitor, this.htmlSanitizer);
        this.fragmentFile = this.repositoryDirectory.newFile("fragment.json");
        this.fragment = FragmentBuilder.aFragment().withName("aUnicornFragment").with(new Element[]{ComponentBuilder.anInput().build()}).build();
        Files.write(this.fragmentFile.toPath(), this.objectMapper.toJson((Object)this.fragment), new OpenOption[0]);
        Mockito.when((Object)this.htmlBuilderVisitor.build(Matchers.anyList())).thenReturn((Object)"");
    }

    @Test
    public void should_build_a_fragment_directive() throws Exception {
        Mockito.when((Object)this.htmlBuilderVisitor.build(Matchers.anyList())).thenReturn((Object)"<p>content</p>");
        this.fragmentDirectiveBuilder.build(this.fragmentFile.toPath());
        String directive = new String(Files.readAllBytes(Paths.get(this.repositoryDirectory.getRoot().toString(), "fragment.js")));
        Assertions.assertThat((String)directive).isEqualTo((Object)this.generateDirective(this.fragment, "<p>content</p>"));
    }

    @Test
    public void should_watch_given_directory_to_build_directives_on_change() throws Exception {
        this.fragmentDirectiveBuilder.start(this.repositoryDirectory.getRoot().toPath());
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)Matchers.eq((Object)this.repositoryDirectory.getRoot().toPath()), (PathListener)Matchers.any(PathListener.class));
    }

    @Test
    public void should_exclude_metadata_from_the_build() throws Exception {
        boolean isBuildable = this.fragmentDirectiveBuilder.isBuildable(".metadata/123.json");
        Assertions.assertThat((boolean)isBuildable).isFalse();
    }

    private String generateDirective(Fragment fragment, String content) throws IOException {
        return this.htmlBuilder.with("rowsHtml", (Object)content).build((Object)fragment);
    }
}

