/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.ApplicationConfig;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.PageRepository;
import org.bonitasoft.web.designer.repository.WidgetRepository;
import org.bonitasoft.web.designer.workspace.WorkspaceInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={ApplicationConfig.class})
@WebAppConfiguration(value="file:target/test-classes")
public class WorkspaceMigrationTest {
    @Value(value="${designer.version}")
    String uidVersion;
    @Value(value="${designer.modelVersion}")
    String modelVersion;
    @Inject
    WorkspaceInitializer workspaceInitializer;
    @Inject
    PageRepository pageRepository;
    @Inject
    WidgetRepository widgetRepository;
    String PAGE_HIGHER_MIGRATION_VERSION = "2.1";
    String WIDGET_HIGHER_MIGRATION_VERSION = "2.1";

    @Before
    public void setUp() throws Exception {
        this.workspaceInitializer.contextInitialized();
        this.workspaceInitializer.migrateWorkspace();
    }

    @Test
    public void should_migrate_a_page() {
        Page page = (Page)this.pageRepository.get("page_1_0_0");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo((Object)this.PAGE_HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo((Object)"1.0.0");
        Assertions.assertThat((Iterable)Iterables.transform((Iterable)page.getAssets(), (Function)new Function<Asset, String>(){

            public String apply(Asset asset) {
                return asset.getId();
            }
        })).doesNotContainNull();
    }

    @Test
    public void should_migrate_a_page_property_values() {
        Page page = (Page)this.pageRepository.get("page_1_0_1");
        Map propertyValues = ((Element)Iterables.concat((Iterable)page.getRows()).iterator().next()).getPropertyValues();
        Assertions.assertThat((Iterable)Iterables.transform(propertyValues.values(), (Function)new Function<PropertyValue, String>(){

            public String apply(PropertyValue value) {
                return value.getType();
            }
        })).doesNotContain((Object[])new String[]{"data"});
    }

    @Test
    public void should_migrate_a_page_adding_text_widget_interpret_HTML_property_value() {
        Page page = (Page)this.pageRepository.get("page_1_5_51");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo((Object)this.PAGE_HIGHER_MIGRATION_VERSION);
        Map propertyValues = ((Element)Iterables.concat((Iterable)page.getRows()).iterator().next()).getPropertyValues();
        PropertyValue allowHTMLProperty = (PropertyValue)propertyValues.get("allowHTML");
        Assertions.assertThat((Object)allowHTMLProperty).isNotNull();
        Assertions.assertThat((String)allowHTMLProperty.getType()).isEqualTo((Object)BondType.CONSTANT.toJson());
        Assertions.assertThat((Object)allowHTMLProperty.getValue()).isEqualTo((Object)Boolean.TRUE);
    }

    @Test
    public void should_migrate_a_widget() {
        Widget widget = (Widget)this.widgetRepository.get("widget_1_0_0");
        Assertions.assertThat((String)widget.getArtifactVersion()).isEqualTo((Object)this.WIDGET_HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)widget.getPreviousArtifactVersion()).isEqualTo((Object)"1.0.0");
        Assertions.assertThat((Iterable)Iterables.transform((Iterable)widget.getAssets(), (Function)new Function<Asset, String>(){

            public String apply(Asset asset) {
                return asset.getId();
            }
        })).doesNotContainNull();
    }

    @Test
    public void should_migrate_a_page_adding_uiBootstrap() {
        Page page = (Page)this.pageRepository.get("page_1_0_1");
        Assertions.assertThat((Iterable)Iterables.transform((Iterable)page.getAssets(), (Function)new Function<Asset, String>(){

            public String apply(Asset asset) {
                return asset.getName();
            }
        })).contains((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"});
    }

    @Test
    public void should_migrate_a_page_not_adding_uiBootstrap_when_already_a_page_asset() {
        Page page = (Page)this.pageRepository.get("pageWithUIBootstrap");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo((Object)this.PAGE_HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo((Object)"1.0.1");
        Assertions.assertThat((Iterable)Iterables.transform((Iterable)page.getAssets(), (Function)new Function<Asset, String>(){

            public String apply(Asset asset) {
                return asset.getName();
            }
        })).doesNotContain((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"}).hasSize(2);
    }

    @Test
    public void should_migrate_a_page_not_adding_uiBootstrap_when_already_a_widget_asset() {
        Page page = (Page)this.pageRepository.get("pageWithUIBootstrapWidget");
        Assertions.assertThat((String)page.getArtifactVersion()).isEqualTo((Object)this.PAGE_HIGHER_MIGRATION_VERSION);
        Assertions.assertThat((String)page.getPreviousArtifactVersion()).isEqualTo((Object)"1.0.1");
        Assertions.assertThat((Iterable)Iterables.transform((Iterable)page.getAssets(), (Function)new Function<Asset, String>(){

            public String apply(Asset asset) {
                return asset.getName();
            }
        })).doesNotContain((Object[])new String[]{"ui-bootstrap-tpls-0.13.0.min.js"}).hasSize(1);
    }
}

