/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.workspace.WorkspacePathResolver;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.env.Environment;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspacePathResolverTest {
    private static final String WORKSPACE_KEY = "workspace";
    @Mock
    private Environment env;
    @InjectMocks
    private WorkspacePathResolver workspacePathResolver;

    @Test
    public void should_resolve_workspace_path_by_getting_system_property() throws Exception {
        Path expectedWorkspacePath = Paths.get("someUserDefinedDirectory", new String[0]);
        Mockito.when((Object)this.env.getProperty(WORKSPACE_KEY)).thenReturn((Object)expectedWorkspacePath.toString());
        Assertions.assertThat((Path)this.workspacePathResolver.getWorkspacePath()).isEqualTo((Object)expectedWorkspacePath);
    }

    @Test
    public void should_have_a_default_value_if_property_is_not_set() throws Exception {
        Mockito.when((Object)this.env.getProperty("user.home")).thenReturn((Object)System.getProperty("user.home"));
        Assertions.assertThat((Path)this.workspacePathResolver.getWorkspacePath()).isEqualTo((Object)Paths.get(System.getProperty("user.home") + "/.bonita", new String[0]));
    }

    @Test
    public void should_retrieve_widgets_repository_path_from_environment_variable() throws Exception {
        Mockito.when((Object)this.env.getProperty("repository.widgets")).thenReturn((Object)"/path/to/widgets");
        Assertions.assertThat((Path)this.workspacePathResolver.getWidgetsRepositoryPath()).isEqualTo((Object)Paths.get("/path/to/widgets", new String[0]));
    }

    @Test
    public void should_resolve_widgets_repository_path() throws Exception {
        Mockito.when((Object)this.env.getProperty("user.home")).thenReturn((Object)System.getProperty("user.home"));
        Assertions.assertThat((Path)this.workspacePathResolver.getWidgetsRepositoryPath()).isEqualTo((Object)Paths.get(System.getProperty("user.home") + "/.bonita/widgets", new String[0]));
    }

    @Test
    public void should_resolve_widgetsWc_repository_path() throws Exception {
        Mockito.when((Object)this.env.getProperty("user.home")).thenReturn((Object)System.getProperty("user.home"));
        Assertions.assertThat((Path)this.workspacePathResolver.getWidgetsWcRepositoryPath()).isEqualTo((Object)Paths.get(System.getProperty("user.home") + "/.bonita/widgetsWc", new String[0]));
    }

    @Test
    public void should_resolve_pages_repository_path() throws Exception {
        Mockito.when((Object)this.env.getProperty("user.home")).thenReturn((Object)System.getProperty("user.home"));
        Assertions.assertThat((Path)this.workspacePathResolver.getPagesRepositoryPath()).isEqualTo((Object)Paths.get(System.getProperty("user.home") + "/.bonita/pages", new String[0]));
    }

    @Test
    public void should_retrieve_pages_repository_path_from_environment_variable() throws Exception {
        Mockito.when((Object)this.env.getProperty("repository.pages")).thenReturn((Object)"path/to/pages");
        Assertions.assertThat((Path)this.workspacePathResolver.getPagesRepositoryPath()).isEqualTo((Object)Paths.get("path/to/pages", new String[0]));
    }

    @Test
    public void should_resolve_fragments_repository_path() throws Exception {
        Mockito.when((Object)this.env.getProperty("user.home")).thenReturn((Object)System.getProperty("user.home"));
        Assertions.assertThat((Path)this.workspacePathResolver.getFragmentsRepositoryPath()).isEqualTo((Object)Paths.get(System.getProperty("user.home") + "/.bonita/fragments", new String[0]));
    }

    @Test
    public void should_retrieve_fragments_repository_path_from_environment_variable() throws Exception {
        Mockito.when((Object)this.env.getProperty("repository.fragments")).thenReturn((Object)"path/to/fragments");
        Assertions.assertThat((Path)this.workspacePathResolver.getFragmentsRepositoryPath()).isEqualTo((Object)Paths.get("path/to/fragments", new String[0]));
    }
}

