/*
 * Decompiled with CFR 0.152.
 */
package boofcv.android;

import android.graphics.Bitmap;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.android.ConvertBitmap;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_I32;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I8;
import org.jetbrains.annotations.Nullable;

public class VisualizeImageData {
    public static void binaryToBitmap(GrayU8 binary, boolean invert, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)binary, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        int indexDst = 0;
        if (invert) {
            for (int y = 0; y < binary.height; ++y) {
                int indexSrc = binary.startIndex + y * binary.stride;
                for (int x = 0; x < binary.width; ++x) {
                    int value = binary.data[indexSrc++] == 0 ? 255 : 0;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = -1;
                }
            }
        } else {
            for (int y = 0; y < binary.height; ++y) {
                int indexSrc = binary.startIndex + y * binary.stride;
                for (int x = 0; x < binary.width; ++x) {
                    int value = binary.data[indexSrc++] == 0 ? 0 : 255;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = (byte)value;
                    storage[indexDst++] = -1;
                }
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void colorizeSign(GrayS16 input, int maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)input, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0) {
            maxAbsValue = ImageStatistics.maxAbs((GrayS16)input);
        }
        int indexDst = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            for (int x = 0; x < input.width; ++x) {
                short value;
                if ((value = input.data[indexSrc++]) > 0) {
                    storage[indexDst++] = (byte)(255 * value / maxAbsValue);
                    storage[indexDst++] = 0;
                    storage[indexDst++] = 0;
                } else {
                    storage[indexDst++] = 0;
                    storage[indexDst++] = (byte)(-255 * value / maxAbsValue);
                    storage[indexDst++] = 0;
                }
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void colorizeSign(GrayF32 input, float maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)input, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs((GrayF32)input);
        }
        int indexDst = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            for (int x = 0; x < input.width; ++x) {
                int n = indexSrc++;
                float value = input.data[n];
                if (value > 0.0f) {
                    storage[indexDst++] = (byte)(255.0f * value / maxAbsValue);
                    storage[indexDst++] = 0;
                    storage[indexDst++] = 0;
                } else {
                    storage[indexDst++] = 0;
                    storage[indexDst++] = (byte)(-255.0f * value / maxAbsValue);
                    storage[indexDst++] = 0;
                }
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void grayMagnitude(GrayS32 input, int maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)input, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0) {
            maxAbsValue = ImageStatistics.maxAbs((GrayS32)input);
        }
        int indexDst = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            for (int x = 0; x < input.width; ++x) {
                byte gray = (byte)(255 * Math.abs(input.data[indexSrc++]) / maxAbsValue);
                storage[indexDst++] = gray;
                storage[indexDst++] = gray;
                storage[indexDst++] = gray;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void grayMagnitude(GrayF32 input, float maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)input, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs((GrayF32)input);
        }
        int indexDst = 0;
        for (int y = 0; y < input.height; ++y) {
            int indexSrc = input.startIndex + y * input.stride;
            for (int x = 0; x < input.width; ++x) {
                byte gray = (byte)(255.0f * Math.abs(input.data[indexSrc++]) / maxAbsValue);
                storage[indexDst++] = gray;
                storage[indexDst++] = gray;
                storage[indexDst++] = gray;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void colorizeGradient(GrayS16 derivX, GrayS16 derivY, int maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)derivX, (ImageBase)derivY, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0) {
            maxAbsValue = ImageStatistics.maxAbs((GrayS16)derivX);
            maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayS16)derivY));
        }
        if (maxAbsValue == 0) {
            return;
        }
        int indexDst = 0;
        for (int y = 0; y < derivX.height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            for (int x = 0; x < derivX.width; ++x) {
                short valueX = derivX.data[indexX++];
                short valueY = derivY.data[indexY++];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0) {
                    r = 255 * valueX / maxAbsValue;
                } else {
                    g = -255 * valueX / maxAbsValue;
                }
                if (valueY > 0) {
                    b = 255 * valueY / maxAbsValue;
                } else {
                    int v = -255 * valueY / maxAbsValue;
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                storage[indexDst++] = (byte)r;
                storage[indexDst++] = (byte)g;
                storage[indexDst++] = (byte)b;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void colorizeGradient(GrayF32 derivX, GrayF32 derivY, float maxAbsValue, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)derivX, (ImageBase)derivY, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        if (maxAbsValue < 0.0f) {
            maxAbsValue = ImageStatistics.maxAbs((GrayF32)derivX);
            maxAbsValue = Math.max(maxAbsValue, ImageStatistics.maxAbs((GrayF32)derivY));
        }
        if (maxAbsValue == 0.0f) {
            return;
        }
        int indexDst = 0;
        for (int y = 0; y < derivX.height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            for (int x = 0; x < derivX.width; ++x) {
                float valueX = derivX.data[indexX++];
                float valueY = derivY.data[indexY++];
                int r = 0;
                int g = 0;
                int b = 0;
                if (valueX > 0.0f) {
                    r = (int)(255.0f * valueX / maxAbsValue);
                } else {
                    g = (int)(-255.0f * valueX / maxAbsValue);
                }
                if (valueY > 0.0f) {
                    b = (int)(255.0f * valueY / maxAbsValue);
                } else {
                    int v = (int)(-255.0f * valueY / maxAbsValue);
                    g += v;
                    if ((r += v) > 255) {
                        r = 255;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                }
                storage[indexDst++] = (byte)r;
                storage[indexDst++] = (byte)g;
                storage[indexDst++] = (byte)b;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void disparity(GrayI disparity, int disparityRange, int invalidColor, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)disparity, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        int indexDst = 0;
        for (int y = 0; y < disparity.height; ++y) {
            for (int x = 0; x < disparity.width; ++x) {
                int b;
                int g;
                int r;
                int v = disparity.unsafe_get(x, y);
                if (v >= disparityRange) {
                    r = invalidColor >> 16 & 0xFF;
                    g = invalidColor >> 8 & 0xFF;
                    b = invalidColor & 0xFF;
                } else {
                    g = 0;
                    if (v == 0) {
                        b = 0;
                        r = 0;
                    } else {
                        r = 255 * v / disparityRange;
                        b = 255 * (disparityRange - v - 1) / disparityRange;
                    }
                }
                storage[indexDst++] = (byte)r;
                storage[indexDst++] = (byte)g;
                storage[indexDst++] = (byte)b;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void disparity(GrayF32 disparity, int disparityRange, int invalidColor, Bitmap output, @Nullable DogArray_I8 _storage) {
        VisualizeImageData.shapeShape((ImageBase)disparity, output);
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        int indexDst = 0;
        for (int y = 0; y < disparity.height; ++y) {
            for (int x = 0; x < disparity.width; ++x) {
                int b;
                int g;
                int r;
                float v = disparity.unsafe_get(x, y);
                if (v >= (float)disparityRange) {
                    r = invalidColor >> 16 & 0xFF;
                    g = invalidColor >> 8 & 0xFF;
                    b = invalidColor & 0xFF;
                } else {
                    g = 0;
                    if (v == 0.0f) {
                        b = 0;
                        r = 0;
                    } else {
                        r = (int)(255.0f * v / (float)disparityRange);
                        b = (int)(255.0f * ((float)disparityRange - v - 1.0f) / (float)disparityRange);
                    }
                }
                storage[indexDst++] = (byte)r;
                storage[indexDst++] = (byte)g;
                storage[indexDst++] = (byte)b;
                storage[indexDst++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void drawEdgeContours(List<EdgeContour> contours, int[] colors, Bitmap output, @Nullable DogArray_I8 _storage) {
        if (output.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Only ARGB_8888 is supported");
        }
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        Arrays.fill(storage, (byte)0);
        for (int i = 0; i < contours.size(); ++i) {
            EdgeContour e = contours.get(i);
            int c = colors[i];
            for (int j = 0; j < e.segments.size(); ++j) {
                EdgeSegment s = (EdgeSegment)e.segments.get(j);
                for (int k = 0; k < s.points.size(); ++k) {
                    Point2D_I32 p = (Point2D_I32)s.points.get(k);
                    int index = p.y * 4 * output.getWidth() + p.x * 4;
                    storage[index++] = (byte)(c >> 16);
                    storage[index++] = (byte)(c >> 8);
                    storage[index++] = (byte)c;
                    storage[index] = -1;
                }
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void drawEdgeContours(List<EdgeContour> contours, int color, Bitmap output, @Nullable DogArray_I8 _storage) {
        if (output.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Only ARGB_8888 is supported");
        }
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        Arrays.fill(storage, (byte)0);
        byte r = (byte)(color >> 16 & 0xFF);
        byte g = (byte)(color >> 8 & 0xFF);
        byte b = (byte)color;
        for (int i = 0; i < contours.size(); ++i) {
            EdgeContour e = contours.get(i);
            for (int j = 0; j < e.segments.size(); ++j) {
                EdgeSegment s = (EdgeSegment)e.segments.get(j);
                for (int k = 0; k < s.points.size(); ++k) {
                    Point2D_I32 p = (Point2D_I32)s.points.get(k);
                    int index = p.y * 4 * output.getWidth() + p.x * 4;
                    storage[index++] = b;
                    storage[index++] = g;
                    storage[index++] = r;
                    storage[index] = -1;
                }
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void renderLabeled(GrayS32 labelImage, int numRegions, Bitmap output, @Nullable DogArray_I8 _storage) {
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        int[] colors = new int[numRegions];
        Random rand = new Random(123L);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = rand.nextInt();
        }
        int w = labelImage.getWidth();
        int h = labelImage.getHeight();
        int indexOut = 0;
        for (int y = 0; y < h; ++y) {
            int indexSrc = labelImage.startIndex + y * labelImage.stride;
            for (int x = 0; x < w; ++x) {
                int rgb = colors[labelImage.data[indexSrc++]];
                storage[indexOut++] = (byte)(rgb & 0xFF);
                storage[indexOut++] = (byte)(rgb >> 8 & 0xFF);
                storage[indexOut++] = (byte)(rgb >> 16 & 0xFF);
                storage[indexOut++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void regionBorders(GrayS32 pixelToRegion, int borderColor, Bitmap output, @Nullable DogArray_I8 _storage) {
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        GrayU8 binary = new GrayU8(pixelToRegion.width, pixelToRegion.height);
        ImageSegmentationOps.markRegionBorders((GrayS32)pixelToRegion, (GrayU8)binary);
        int indexOut = 0;
        for (int y = 0; y < binary.height; ++y) {
            for (int x = 0; x < binary.width; ++x) {
                if (binary.unsafe_get(x, y) != 0) {
                    storage[indexOut++] = (byte)(borderColor & 0xFF);
                    storage[indexOut++] = (byte)(borderColor >> 8 & 0xFF);
                    storage[indexOut++] = (byte)(borderColor >> 16 & 0xFF);
                    storage[indexOut++] = -1;
                    continue;
                }
                indexOut += 4;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    public static void regionsColor(GrayS32 pixelToRegion, DogArray<float[]> segmentColor, Bitmap output, @Nullable DogArray_I8 _storage) {
        _storage = ConvertBitmap.resizeStorage(output, _storage);
        byte[] storage = _storage.data;
        int indexOut = 0;
        for (int y = 0; y < pixelToRegion.height; ++y) {
            for (int x = 0; x < pixelToRegion.width; ++x) {
                int b;
                int g;
                int r;
                int index = pixelToRegion.unsafe_get(x, y);
                float[] cv = (float[])segmentColor.get(index);
                if (cv.length == 3) {
                    r = (int)cv[0];
                    g = (int)cv[1];
                    b = (int)cv[2];
                } else {
                    g = b = (int)cv[0];
                    r = b;
                }
                storage[indexOut++] = (byte)r;
                storage[indexOut++] = (byte)g;
                storage[indexOut++] = (byte)b;
                storage[indexOut++] = -1;
            }
        }
        output.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(storage));
    }

    private static void shapeShape(ImageBase input, Bitmap output) {
        if (output.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Only ARGB_8888 is supported");
        }
        if (input.width != output.getWidth() || input.height != output.getHeight()) {
            throw new IllegalArgumentException("Input and output must have the same shape");
        }
    }

    private static void shapeShape(ImageBase input0, ImageBase input1, Bitmap output) {
        if (output.getConfig() != Bitmap.Config.ARGB_8888) {
            throw new IllegalArgumentException("Only ARGB_8888 is supported");
        }
        if (input0.width != output.getWidth() || input0.height != output.getHeight()) {
            throw new IllegalArgumentException("Input and output must have the same shape");
        }
        if (input1.width != output.getWidth() || input1.height != output.getHeight()) {
            throw new IllegalArgumentException("Input and output must have the same shape");
        }
    }
}

